/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import com.alibaba.fastjson.JSONObject;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.web.bind.annotation.RequestParam;

@Endpoint(id="flow-record-result")
public class RecordResultMvcEndpoint {
    @ReadOperation
    public String invoke(@RequestParam Long usecaseSetId) {
        JsonResult<Object> result;
        try {
            RecordContext context = RecordContextHolder.getRecordContext();
            if (context == null) {
                throw new FlowReplayException("\u5f55\u5236\u672a\u5f00\u59cb");
            }
            if (!usecaseSetId.equals(context.getUsecaseSetId())) {
                throw new FlowReplayException("\u975e\u6cd5\u7684\u7528\u4f8b\u96c6ID");
            }
            JSONObject recordResult = new JSONObject();
            if (!RecordContextHolder.isRecording() && context.getRecordResult() != null) {
                recordResult.put("isEnded", (Object)true);
                recordResult.put("result", (Object)context.getRecordResult());
            } else {
                recordResult.put("isEnded", (Object)false);
                recordResult.put("result", null);
            }
            result = JsonResult.successResult(recordResult);
        }
        catch (Exception e) {
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }
}

