/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping.dubbo;

import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.AbstractRouter;

public class ServiceGroupDubboRouter
extends AbstractRouter {
    public ServiceGroupDubboRouter(URL url) {
        this.url = url;
    }

    public <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        if (CollectionUtils.isEmpty(invokers)) {
            return invokers;
        }
        String currentServiceGroupKey = ServiceGroupContext.getCurrentGroupKey();
        ArrayList<Invoker<T>> havePriorityList = new ArrayList<Invoker<T>>(invokers.size());
        ArrayList<Invoker<T>> noGroupKeyInvokerList = new ArrayList<Invoker<T>>(invokers.size());
        for (Invoker<T> invoker : invokers) {
            String targetNodeIp;
            String invokerGroupKey = invoker.getUrl().getParameter("serviceGroupKey");
            if (this.groupKeyEquals(currentServiceGroupKey, invokerGroupKey, targetNodeIp = invoker.getUrl().getIp())) {
                havePriorityList.add(invoker);
            }
            if (!StringUtils.isBlank((CharSequence)invokerGroupKey)) continue;
            noGroupKeyInvokerList.add(invoker);
        }
        if (!havePriorityList.isEmpty()) {
            return havePriorityList;
        }
        if (StringUtils.isNotBlank((CharSequence)currentServiceGroupKey) && !noGroupKeyInvokerList.isEmpty()) {
            return noGroupKeyInvokerList;
        }
        return invokers;
    }

    private boolean groupKeyEquals(String requestGroupKey, String serverGroupKey, String targetNodeIp) {
        if (StringUtils.isBlank((CharSequence)requestGroupKey)) {
            requestGroupKey = "";
        }
        if (StringUtils.isBlank((CharSequence)serverGroupKey)) {
            serverGroupKey = "";
        }
        if (StringUtils.equals((CharSequence)requestGroupKey, (CharSequence)serverGroupKey)) {
            return true;
        }
        if (requestGroupKey.startsWith("dev_ip_")) {
            String ipFromRequest = requestGroupKey.substring("dev_ip_".length());
            return ipFromRequest.equals(targetNodeIp);
        }
        return false;
    }
}

