package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign;

import feign.Client;
import org.apache.http.client.HttpClient;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * feign-httpclient升级到 10.10.1 之后，存在问题，会导致post和put的在query中的无法加到form中，当参数过长的时候会报错
 * 此处通过产生一个自定义的 CustomApacheHttpClient 来替换feign原生的 ApacheHttpClient，以解决该问题
 * Created by guoyanfei .
 * 2020/11/18 .
 */
@Configuration(proxyBeanMethods = false)
@ConditionalOnClass(CustomApacheHttpClient.class)
@ConditionalOnProperty(value = "feign.httpclient.enabled", matchIfMissing = true)
@AutoConfigureBefore(name = "org.springframework.cloud.openfeign.ribbon.FeignRibbonClientAutoConfiguration")
public class CustomHttpClientFeignLoadBalancedAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean(Client.class)
    public Client feignClient(CachingSpringLoadBalancerFactory cachingFactory, SpringClientFactory clientFactory, HttpClient httpClient) {
        CustomApacheHttpClient delegate = new CustomApacheHttpClient(httpClient);
        return new LoadBalancerFeignClient(delegate, cachingFactory, clientFactory);
    }

}
