package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.sleuth.instrument.web.TraceWebServletAutoConfiguration;
import org.springframework.core.annotation.Order;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;


/**
 * 这个拦截器只用来做最初的请求判定，在后续的分布式调用中不起作用
 */
@Order(TraceWebServletAutoConfiguration.TRACING_FILTER_ORDER-1)
public class DuibaTraceFilter implements Filter {

    public static final String ZIPKIN_MODEL = "_traceMode";

    @Override
    public void init(FilterConfig filterConfig) {
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;

        String model = request.getParameter(ZIPKIN_MODEL);
        String header = request.getHeader(ZipkinConstants.SPAN_FLAGS);

        //检测到用户安装了zipkin chrome插件或者url中有_traceMode=DEBUG的参数，则开启调试模式，调试模式下强制对该请求的分布式日志开启debug级别，并记录feign调用的参数
        Boolean isDebugRunMode = StringUtils.equalsIgnoreCase(model,"DEBUG") || ZipkinConstants.SPAN_SAMPLED.equals(header);
        ZipkinRequest zipkinRequest = new ZipkinRequest(request);
        zipkinRequest.setDebugMode(isDebugRunMode);

        if(isDebugRunMode){
            zipkinRequest.setAttribute(ZipkinConstants.SPAN_FLAGS,ZipkinConstants.SPAN_SAMPLED);
        }else{
            zipkinRequest.setAttribute(ZipkinConstants.SPAN_FLAGS,ZipkinConstants.SPAN_NOT_SAMPLED);
        }
        filterChain.doFilter(zipkinRequest,servletResponse);

    }

    @Override
    public void destroy() {
        //do nothing
    }

}
