package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.apache.shardingsphere.encrypt.api.EncryptRuleConfiguration;

import java.util.Properties;

/**
 * 数据库加密配置cache
 * Created by gyf .
 * 2020/8/4 .
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class DBEncryptConfig {

    private String datasource;

    private EncryptRuleConfiguration encryptRuleConfiguration;

    /**
     * 优先取policy设置的props
     * 如果policy没有单独设置，那么取全局的props
     */
    private Properties props;

}
