package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

/**
 * 数据库加密配置
 * Created by gyf .
 * 2020/8/4 .
 */
@Getter
@Setter
@ConfigurationProperties(prefix = DuibaDBEncryptProperties.DUIBA_DB_ENCRYPT_PREFIX)
public class DuibaDBEncryptProperties {

    public static final String DUIBA_DB_ENCRYPT_PREFIX = "duiba.db.encrypt";

    /**
     * 加密器的配置
     * key: 加密器名称
     * value: 加密器相关配置
     */
    private Map<String, DBEncryptorRule> encryptors = new LinkedHashMap<>();

    /**
     * 加密规则的配置
     * key: 规则名称
     * value: 规则内容
     */
    private Map<String, DBEncryptPolicy> policy = new LinkedHashMap<>();

    /**
     * 其他相关属性配置(全局配置)
     * 比如:
     * duiba.db.encrypt.props.query.with.cipher.column=false
     * duiba.db.encrypt.props.sql.show=true
     */
    private Properties props = new Properties();

}
