package cn.com.duibaboot.ext.autoconfigure.perftest;

import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.data.redis.connection.jedis.JedisConnection;

/**
 * Created by guoyanfei .
 * 2018/11/2 .
 */
@Aspect
public class PerfTestSpringDataRedisPlugin {

    @Resource
    private PerfTestFootMarker perfTestFootMarker;

    @Around("execution(* org.springframework.data.redis.connection.jedis.JedisConnectionFactory.getConnection(..))")
    public Object springDataRedisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable{
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if ("getConnection".equals(methodName)) {
            Object connectionObj = joinPoint.proceed();
            if (connectionObj instanceof JedisConnection) {
                JedisConnection connection = (JedisConnection) connectionObj;
                perfTestFootMarker.markRedis(this.getHost(connection));
            }
            // connectionObj 有可能是 JedisClusterConnection，这种情况下暂时不支持集群的压测实时监控
            return connectionObj;
        }
        return joinPoint.proceed();
    }

    private String getHost(JedisConnection connection) {
        if (connection == null) {
            return null;
        }
        if (connection.getNativeConnection() == null) {
            return null;
        }
        if (connection.getNativeConnection().getClient() == null) {
            return null;
        }
        return connection.getNativeConnection().getClient().getHost();
    }
}
