package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duibaboot.ext.autoconfigure.cat.context.CatInstance;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.ReactiveHttpRequestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

/**
 * Feature拦截器, 提供/_disableFeature, /_enableFeature两个url,用于启用/禁用cat等特性
 * <br/>
 * 比如调用/_enableFeature?type=cat表示启用cat，调用/_disableFeature?type=cat表示禁用cat
 */
@Order(Ordered.HIGHEST_PRECEDENCE + 1)//最高优先级,但不能比CharacterEncodingFilter高
public class FeatureReactiveFilter implements WebFilter {

    private Mono<Void> enableFeature(ServerWebExchange exchange, boolean isEnable) {
        if(!ReactiveHttpRequestUtils.isLocalRequest(exchange.getRequest())){
            return ReactiveHttpRequestUtils.write(exchange.getResponse(), "NO PERMISSION");
        }
        String type = exchange.getRequest().getQueryParams().getFirst("type");
        if(StringUtils.isBlank(type)){
            return ReactiveHttpRequestUtils.write(exchange.getResponse(), "ERROR");
        }

        if(type.equals("cat") && CatUtils.isCatClassExists()){
            if(isEnable){
                CatInstance.enable();
            }else{
                CatInstance.disable();
            }
        }else{
            return ReactiveHttpRequestUtils.write(exchange.getResponse(), "ERROR");
        }

        return ReactiveHttpRequestUtils.write(exchange.getResponse(), "OK");
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String requestPath = exchange.getRequest().getPath().pathWithinApplication().value();
        if(requestPath.equals("/_disableFeature")){
            return enableFeature(exchange, false);
        }else if(requestPath.equals("/_enableFeature")){
            return enableFeature(exchange, true);
        }

        return chain.filter(exchange);
    }
}
