/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.config;

import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.JetcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.RestEtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.etcd.config.EtcdConfigProperties;
import cn.com.duibaboot.ext.autoconfigure.etcd.config.EtcdPropertySourceLocator;
import com.google.common.base.Strings;
import io.etcd.jetcd.Client;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class EtcdConfigApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static Log logger = LogFactory.getLog(EtcdConfigApplicationContextInitializer.class);
    private int order = -2147483636;
    private static volatile EtcdKVClientDelegate client;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        ConfigurableEnvironment configurableEnvironment = configurableApplicationContext.getEnvironment();
        String uri = configurableEnvironment.getProperty("duiba.cloud.etcd.uris");
        if (!Strings.isNullOrEmpty((String)uri)) {
            try {
                EtcdConfigProperties etcdConfigProperties = new EtcdConfigProperties();
                if (client == null) {
                    this.initClient(uri.split(","));
                }
                EtcdPropertySourceLocator etcdPropertySourceLocator = new EtcdPropertySourceLocator(client, etcdConfigProperties);
                PropertySource<?> propertySource = etcdPropertySourceLocator.locate((Environment)configurableEnvironment);
                configurableEnvironment.getPropertySources().addFirst(propertySource);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void initClient(String[] uris) {
        try {
            Class.forName("com.coreos.jetcd.Client");
            client = new JetcdKVClientDelegate(Client.builder().endpoints(uris).build());
        }
        catch (ClassNotFoundException e) {
            client = new RestEtcdKVClientDelegate(uris);
        }
    }
}

