/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.devtools;

import cn.com.duibaboot.ext.autoconfigure.core.utils.ReactiveHttpRequestUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.SpringBootUtils;
import cn.com.duibaboot.ext.autoconfigure.devtools.ClassPathChangedFilesContainer;
import com.alibaba.fastjson.JSONObject;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.boot.devtools.filewatch.ChangedFiles;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class BootDevToolsReactiveFilter
implements WebFilter {
    private boolean canHotRestart = false;
    private String errorMsg;
    private volatile boolean isHotRestarting = false;
    private ClassPathChangedFilesContainer classPathChangedFilesContainer;

    public BootDevToolsReactiveFilter(ApplicationContext applicationContext, ClassPathChangedFilesContainer classPathChangedFilesContainer) {
        this.classPathChangedFilesContainer = classPathChangedFilesContainer;
        Environment environment = applicationContext.getEnvironment();
        if (SpringBootUtils.isJarInJarMode()) {
            this.errorMsg = "\u68c0\u6d4b\u5230\u4f60\u7684\u5e94\u7528\u5728java -jar\u6a21\u5f0f\u4e0b\u8fd0\u884c\uff0c\u8be5\u6a21\u5f0f\u65e0\u6cd5\u4f7f\u7528\u70ed\u91cd\u542f\u529f\u80fd\uff0c\u5982\u9700\u4f7f\u7528\u70ed\u91cd\u542f\uff0c\u8bf7\u5728IDEA\u3001Eclipse\u7b49IDE\u4e2d\u76f4\u63a5\u8fd0\u884c";
        } else if ("false".equals(environment.getProperty("spring.devtools.restart.enabled"))) {
            this.errorMsg = "\u68c0\u6d4b\u5230\u4f60\u7684\u5e94\u7528\u914d\u7f6e\u4e86spring.devtools.restart.enabled=false\uff0c\u8fd9\u8868\u793a\u7981\u7528\u4e86\u5f00\u53d1\u65f6\u70ed\u91cd\u542f\u529f\u80fd\uff1b\u5982\u9700\u4f7f\u7528\u70ed\u91cd\u542f\uff0c\u8bf7\u79fb\u9664\u8be5\u914d\u7f6e\u3002\uff08\u4f60\u53ef\u4ee5\u653e\u5fc3\u79fb\u9664\u8be5\u914d\u7f6e\uff0c\u8fd9\u4e2a\u914d\u7f6e\u53ea\u5f71\u54cd\u5f00\u53d1\u73af\u5883\uff09";
        } else if (this.isDevToolsNotInClassPath() || classPathChangedFilesContainer == null) {
            this.errorMsg = "\u6ca1\u6709\u68c0\u6d4b\u5230spring-boot-devtools\u4f9d\u8d56(\u70ed\u91cd\u542f\u4f9d\u8d56\u4e8e\u4e4b)\uff0c\u8bf7\u68c0\u67e5\u60a8\u662f\u5426\u5347\u7ea7\u5230\u4e86\u6700\u65b0\u7684\u5151\u5427spring-boot-ext\u4f9d\u8d56\uff0c\u6216\u8005\u60a8\u662f\u5426\u6392\u9664\u4e86\u8be5\u4f9d\u8d56\u3002";
        } else {
            this.canHotRestart = true;
        }
    }

    public Mono<Void> error(String message, ServerHttpResponse response) {
        JSONObject json = new JSONObject();
        json.fluentPut("success", (Object)"true").fluentPut("canHotRestart", (Object)this.canHotRestart).fluentPut("hotRestarting", (Object)this.isHotRestarting).fluentPut("message", (Object)message);
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON_UTF8);
        return ReactiveHttpRequestUtils.write(response, json.toString());
    }

    private boolean isDevToolsNotInClassPath() {
        try {
            Class.forName("org.springframework.boot.devtools.restart.classloader.RestartClassLoader");
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String uri = exchange.getRequest().getPath().pathWithinApplication().value();
        if (uri.equals("/devtools/check")) {
            if (!this.canHotRestart) {
                return this.error(this.errorMsg, exchange.getResponse());
            }
            if (this.isHotRestarting) {
                return this.error("\u6b63\u5728\u70ed\u91cd\u542f\u4e2d,\u8bf7\u7a0d\u5019...", exchange.getResponse());
            }
            return this.error("\u68c0\u6d4b\u5230\u5f53\u524d\u5e94\u7528\u652f\u6301\u70ed\u91cd\u542f, \u5982\u9700\u8981\u70ed\u91cd\u542f\uff0c\u8bf7\u70b9\u51fb\u4e0b\u9762\u7684\u6309\u94ae", exchange.getResponse());
        }
        if (uri.equals("/devtools/restart")) {
            if (!this.canHotRestart) {
                return this.error(this.errorMsg, exchange.getResponse());
            }
            if (this.isHotRestarting) {
                return this.error("\u6b63\u5728\u70ed\u91cd\u542f\u4e2d,\u8bf7\u7a0d\u5019...", exchange.getResponse());
            }
            Set<ChangedFiles> changedFilesSet = this.classPathChangedFilesContainer.getChangedFilesAndClear();
            Object[] scanUrls = Restarter.getInstance().getInitialUrls();
            if (changedFilesSet.isEmpty() && !ArrayUtils.isEmpty((Object[])scanUrls)) {
                return this.error("<span style='font-size:20px;'>\u6ca1\u6709\u7c7b\u53d1\u751f\u53d8\u52a8\uff0c\u4e0d\u9700\u8981\u70ed\u91cd\u542f</span><br/>(\u5982\u679c\u4f60\u4fee\u6539\u4e86java\u4ee3\u7801\uff0c\u5728IDEA\u4e2d\u9700\u8981\u5148\u624b\u52a8\u70b9\u51fb\u83dc\u5355\u3010Build -> Build Project\u3011\u89e6\u53d1\u7f16\u8bd1\u4ee3\u7801;<br/>\u5728Eclipse\u4e2d\u5219\u53ea\u9700\u4fdd\u5b58\u4ee3\u7801\u5373\u53ef\u81ea\u52a8\u89e6\u53d1\u7f16\u8bd1\u4ee3\u7801;<br/>\u4ee3\u7801\u7f16\u8bd1\u5b8c\u6210\u540e\u518d\u5230\u8fd9\u91cc\u91cd\u542f)", exchange.getResponse());
            }
            this.isHotRestarting = true;
            return this.error("\u6210\u529f\u8bf7\u6c42\u70ed\u91cd\u542f\uff0c\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u5173\u6ce8IDE\u63a7\u5236\u53f0\u3002", exchange.getResponse()).then(Mono.fromFuture(CompletableFuture.runAsync(() -> this.classPathChangedFilesContainer.requestRestart(changedFilesSet))));
        }
        return chain.filter(exchange);
    }
}

