/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordEndEvent;
import java.io.IOException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class RecordResultBuilder {
    private static final Logger log = LoggerFactory.getLogger(RecordResultBuilder.class);
    @Resource
    private FlowReplayFileComponent flowReplayFileComponent;

    @EventListener(value={RecordEndEvent.class})
    public void recordEndEventListener(final RecordEndEvent event) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RecordContext context = RecordContextHolder.getRecordContext();
                if (context == null) {
                    return;
                }
                String usecaseSetOssPath = null;
                String recordDetailOssPath = null;
                try {
                    usecaseSetOssPath = RecordResultBuilder.this.flowReplayFileComponent.upload("/data/flowreplay/flow_record");
                    recordDetailOssPath = RecordResultBuilder.this.flowReplayFileComponent.upload("/data/flowreplay/flow_record_detail");
                }
                catch (IOException e) {
                    log.error("\u7528\u4f8b\u96c6/\u5f55\u5236\u8be6\u60c5_\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
                }
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                String applicationLogUrl = null;
                try {
                    applicationLogUrl = RecordResultBuilder.this.flowReplayFileComponent.upload("/data/flowreplaylog/recordlog");
                    RecordResultBuilder.this.flowReplayFileComponent.clearFile("/data/flowreplaylog/recordlog/record.log");
                }
                catch (IOException e) {
                    log.error("\u4e0a\u4f20\u5e94\u7528\u65e5\u5fd7_\u6587\u4ef6\u64cd\u4f5c\u5f02\u5e38_usecaseSetId_{}", (Object)context.getUsecaseSetId(), (Object)e);
                }
                FlowReplayFileComponent.removeDir();
                RecordResult result = new RecordResult();
                result.setUsecaseSetId(context.getUsecaseSetId());
                result.setNormal(event.isNormal());
                result.setMessage(event.getMessage());
                result.setOssPath(usecaseSetOssPath);
                result.setFileSize(context.getCurrentFileSize());
                result.setRecordDetailPath(recordDetailOssPath);
                result.setApplicationLogUrl(applicationLogUrl);
                result.setStartTime(context.getStartTime());
                result.setEndTime(context.getEndTime());
                context.setRecordResult(result);
            }
        }, "DBThread-Record-Upload").start();
    }
}

