/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.loader;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptorInstanceLoader {
    private static final Logger logger = LoggerFactory.getLogger((String)InterceptorInstanceLoader.class.getName());
    private static final ConcurrentHashMap<String, Object> INSTANCE_CACHE = new ConcurrentHashMap();
    private static final ReentrantLock INSTANCE_LOAD_LOCK = new ReentrantLock();

    public static <T> T load(String className, ClassLoader targetClassLoader) throws InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        String instanceKey;
        Object inst;
        if (targetClassLoader == null) {
            targetClassLoader = InterceptorInstanceLoader.class.getClassLoader();
        }
        if ((inst = INSTANCE_CACHE.get(instanceKey = className + "_OF_" + targetClassLoader.getClass().getName() + "@" + Integer.toHexString(targetClassLoader.hashCode()))) == null) {
            inst = InterceptorInstanceLoader.loadInner(className, targetClassLoader, instanceKey);
        }
        return (T)inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T loadInner(String className, ClassLoader targetClassLoader, String instanceKey) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Object inst;
        if (InterceptorInstanceLoader.class.getClassLoader().equals(targetClassLoader)) {
            inst = targetClassLoader.loadClass(className).newInstance();
        } else {
            INSTANCE_LOAD_LOCK.lock();
            try {
                try {
                    inst = InterceptorInstanceLoader.findLoadedClass(className, targetClassLoader);
                    if (inst == null) {
                        inst = InterceptorInstanceLoader.loadBinary(className, targetClassLoader);
                    }
                    if (inst == null) {
                        throw new ClassNotFoundException(targetClassLoader.toString() + " load interceptor class:" + className + " failure.");
                    }
                }
                catch (Exception e) {
                    throw new ClassNotFoundException(targetClassLoader.toString() + " load interceptor class:" + className + " failure.", e);
                }
            }
            finally {
                INSTANCE_LOAD_LOCK.unlock();
            }
        }
        if (inst != null) {
            INSTANCE_CACHE.put(instanceKey, inst);
        }
        return (T)inst;
    }

    private static <T> T loadBinary(String className, ClassLoader targetClassLoader) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        String path = "/" + className.replace('.', '/').concat(".class");
        byte[] data = null;
        try (BufferedInputStream is = new BufferedInputStream(InterceptorInstanceLoader.class.getResourceAsStream(path));
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            if (logger.isInfoEnabled()) {
                logger.info("Read binary code of " + className);
            }
            int ch = 0;
            while ((ch = is.read()) != -1) {
                baos.write(ch);
            }
            data = baos.toByteArray();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        Method defineClassMethod = null;
        Class<?> targetClassLoaderType = targetClassLoader.getClass();
        while (defineClassMethod == null && targetClassLoaderType != null) {
            try {
                defineClassMethod = targetClassLoaderType.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            }
            catch (NoSuchMethodException e) {
                targetClassLoaderType = targetClassLoaderType.getSuperclass();
            }
        }
        if (defineClassMethod == null) {
            throw new NullPointerException("[NOTIFYME]method: defineClass is not exists");
        }
        if (data == null) {
            throw new NullPointerException("[NOTIFYME]data is not exists");
        }
        defineClassMethod.setAccessible(true);
        if (logger.isInfoEnabled()) {
            logger.info("load binary code of " + className + " to classloader " + targetClassLoader);
        }
        Class type = (Class)defineClassMethod.invoke((Object)targetClassLoader, className, data, 0, data.length, null);
        return type.newInstance();
    }

    private static <T> T findLoadedClass(String className, ClassLoader targetClassLoader) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Method defineClassMethod = null;
        Class<?> targetClassLoaderType = targetClassLoader.getClass();
        while (defineClassMethod == null && targetClassLoaderType != null) {
            try {
                defineClassMethod = targetClassLoaderType.getDeclaredMethod("findLoadedClass", String.class);
            }
            catch (NoSuchMethodException e) {
                targetClassLoaderType = targetClassLoaderType.getSuperclass();
            }
        }
        if (defineClassMethod == null) {
            throw new NullPointerException("[NOTIFYME]method: findLoadedClass is not exists");
        }
        defineClassMethod.setAccessible(true);
        Class type = (Class)defineClassMethod.invoke((Object)targetClassLoader, className);
        if (type == null) {
            return null;
        }
        return type.newInstance();
    }
}

