/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.limiter;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.utils.AopTargetUtils;
import cn.com.duibaboot.ext.autoconfigure.limiter.ServerApiEndpoint;
import cn.com.duibaboot.ext.autoconfigure.limiter.ServerLimiterAutoConfiguration;
import cn.com.duibaboot.ext.autoconfigure.limiter.SpringMvcConfigForLimiter;
import com.google.common.collect.Sets;
import feign.Feign;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.EventListener;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@Import(value={ServerLimiterAutoConfiguration.class, SpringMvcConfigForLimiter.class})
public class ServerApiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ServerApiAutoConfiguration.class);
    private static final Set<String> selfFeignClients = Sets.newHashSet();

    public static Set<String> getSelfFeignClients() {
        return selfFeignClients;
    }

    @Configuration
    public static class ServerApiEndpointConfiguration {
        @Bean
        public ServerApiEndpoint serverApiEndpointConfiguration() {
            return new ServerApiEndpoint();
        }
    }

    @Configuration
    @ConditionalOnClass(value={AdvancedFeignClient.class, RestController.class})
    public static class SpringCloudServerApiAutoConfiguration
    implements ApplicationContextAware {
        private ApplicationContext applicationContext;

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        @EventListener(value={MainContextRefreshedEvent.class})
        public void initSelfFeignClients() {
            Map beanMap = this.applicationContext.getBeansWithAnnotation(RestController.class);
            this.buildBeanDefinition(beanMap, classInstance -> classInstance.isAnnotationPresent(AdvancedFeignClient.class));
        }

        private void buildBeanDefinition(Map<String, Object> beanMap, Function<Class<?>, Boolean> isAnnotation) {
            if (beanMap == null || beanMap.size() == 0) {
                return;
            }
            beanMap.values().forEach(bean -> {
                Object aopTargetObject = bean;
                try {
                    while (AopTargetUtils.getTarget((Object)aopTargetObject) != aopTargetObject) {
                        aopTargetObject = AopTargetUtils.getTarget((Object)aopTargetObject);
                    }
                }
                catch (Exception e) {
                    aopTargetObject = bean;
                }
                Class<?>[] interfaceClasses = aopTargetObject.getClass().getInterfaces();
                if (interfaceClasses == null || interfaceClasses.length == 0) {
                    return;
                }
                this.buildUniqKey(interfaceClasses, isAnnotation);
            });
        }

        private void buildUniqKey(Class<?>[] interfaceClasses, Function<Class<?>, Boolean> isAnnotation) {
            for (Class<?> interfaceClass : interfaceClasses) {
                try {
                    Method[] methods;
                    if (!isAnnotation.apply(interfaceClass).booleanValue()) continue;
                    for (Method method : methods = interfaceClass.getMethods()) {
                        selfFeignClients.add(Feign.configKey(interfaceClass, (Method)method));
                    }
                }
                catch (Exception e) {
                    log.info("\u52a0\u8f7dspringCloud\u63a5\u53e3\u9519\u8bef, class:{}", interfaceClass, (Object)e);
                }
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Service.class, ApplicationModel.class})
    public static class DubboServerApiAutoConfiguration {
        @EventListener(value={MainContextRefreshedEvent.class})
        public void initSelfFeignClients() {
            Collection providerModels = ApplicationModel.allProviderModels();
            if (providerModels.isEmpty()) {
                return;
            }
            providerModels.forEach(providerModel -> {
                List providerMethodModels = providerModel.getAllMethods();
                Class interfaceClass = providerModel.getServiceInterfaceClass();
                providerMethodModels.forEach(providerMethodModel -> selfFeignClients.add(Feign.configKey((Class)interfaceClass, (Method)providerMethodModel.getMethod())));
            });
        }
    }
}

