/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.threadpool.proxy.MonitorRunnable;
import com.google.common.base.Throwables;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileRunnable
extends MonitorRunnable {
    private static final Logger logger = LoggerFactory.getLogger(ProfileRunnable.class);
    private String threadPoolName = "undefined";

    public ProfileRunnable(Runnable runnable) {
        super(runnable);
    }

    public ProfileRunnable(Runnable runnable, BlockingQueue<Runnable> queue, String threadPoolName) {
        super(runnable, queue);
        this.threadPoolName = threadPoolName;
    }

    @Override
    public void run() {
        DBTimeProfile.start();
        Runnable runnable = this.getRootRunnable();
        String rootRunnableClassName = runnable.getClass().getName();
        try {
            CatUtils.executeInCatTransaction(() -> {
                super.run();
                return null;
            }, "ThreadPool", "(" + this.threadPoolName + ")" + rootRunnableClassName);
        }
        catch (Throwable throwable) {
            logger.error("", throwable);
            throw Throwables.propagate((Throwable)throwable);
        }
        finally {
            DBTimeProfile.end((String)(rootRunnableClassName + ", thread:" + Thread.currentThread().getName()));
        }
    }
}

