/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStatusHolder {
    private static final Logger log = LoggerFactory.getLogger(ServerStatusHolder.class);
    private static volatile boolean inService = false;
    private static List<ServiceStatusChangedListener> serviceStatusChangedListeners = new CopyOnWriteArrayList<ServiceStatusChangedListener>();

    public static boolean isInService() {
        return inService;
    }

    public static synchronized void setInService(boolean inService) {
        ServerStatusHolder.inService = inService;
        for (ServiceStatusChangedListener listener : serviceStatusChangedListeners) {
            try {
                listener.onServiceStatusChanged(inService);
            }
            catch (Throwable e) {
                log.warn("Call ServiceStatusChangedListener error:", e);
            }
        }
    }

    public static void registerServiceStatusChangedListener(ServiceStatusChangedListener listener) {
        if (!serviceStatusChangedListeners.contains(listener)) {
            serviceStatusChangedListeners.add(listener);
        }
    }

    public static void unregisterServiceStatusChangedListener(ServiceStatusChangedListener listener) {
        serviceStatusChangedListeners.remove(listener);
    }

    public static interface ServiceStatusChangedListener {
        public void onServiceStatusChanged(boolean var1);
    }
}

