/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.batch;

import cn.com.duibaboot.ext.autoconfigure.batch.BatchProperties;
import cn.com.duibaboot.ext.autoconfigure.batch.ReqContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;

public class ReqBucket {
    private static final ConcurrentMap<String, Bucket> buckets = new ConcurrentHashMap<String, Bucket>();
    @Resource
    private BatchProperties properties;

    public void submit(ReqContext req) {
        String bucketId = req.getFullMethodName();
        if (req.isCurrentInPerfTestMode()) {
            bucketId = "PerfTest:" + bucketId;
        }
        Bucket bucket = buckets.computeIfAbsent(bucketId, k -> new Bucket());
        req.setState(0);
        bucket.submit(req);
    }

    public Map<String, List<ReqContext>> poll(int num) {
        HashMap<String, List<ReqContext>> reqs = new HashMap<String, List<ReqContext>>();
        for (Map.Entry entry : buckets.entrySet()) {
            List<ReqContext> batch;
            Bucket bucket = (Bucket)entry.getValue();
            if (bucket == null || (batch = bucket.poll(num)).isEmpty()) continue;
            reqs.put((String)entry.getKey(), batch);
        }
        return reqs;
    }

    class Bucket {
        private AtomicLong size = new AtomicLong(0L);
        private ConcurrentLinkedQueue<ReqContext> queue = new ConcurrentLinkedQueue();

        Bucket() {
        }

        public void canSubmit() {
            long wait;
            ReqContext req = this.queue.peek();
            if (req != null && (wait = System.currentTimeMillis() - req.getTimestamp()) > 10L) {
                throw new RejectedExecutionException("Queue wait:" + wait + "ms");
            }
            if (this.size.get() >= (long)ReqBucket.this.properties.getMaxqueue()) {
                throw new RejectedExecutionException("Queue is Full :" + ReqBucket.this.properties.getMaxqueue());
            }
        }

        public void submit(ReqContext req) {
            this.canSubmit();
            this.size.incrementAndGet();
            this.queue.add(req);
        }

        public List<ReqContext> poll(int num) {
            ReqContext req;
            ArrayList<ReqContext> reqs = new ArrayList<ReqContext>(num);
            for (int i = 0; i < num && (req = this.queue.poll()) != null; ++i) {
                reqs.add(req);
                req.setState(1);
            }
            int batchNum = reqs.size();
            if (batchNum > 0) {
                this.size.getAndAdd(-batchNum);
            }
            return reqs;
        }
    }
}

