/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource;

import cn.com.duibaboot.ext.autoconfigure.datasource.DataSourceBeanDefinitionRegistryPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

public class DuibaDataSourceRegistryContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger logger = LoggerFactory.getLogger(DuibaDataSourceRegistryContextInitializer.class);
    private static volatile boolean isSpringJdbcJarImported;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (!isSpringJdbcJarImported) {
            return;
        }
        DataSourceBeanDefinitionRegistryPostProcessor processor = new DataSourceBeanDefinitionRegistryPostProcessor();
        processor.setEnvironment((Environment)applicationContext.getEnvironment());
        applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)processor);
    }

    static {
        boolean isSpringJdbcJarImportedTemp = false;
        try {
            Class.forName("org.springframework.jdbc.core.JdbcTemplate");
            isSpringJdbcJarImportedTemp = true;
        }
        catch (ClassNotFoundException e) {
            logger.debug("\u6ca1\u6709\u68c0\u6d4b\u5230spring-jdbc\u4f9d\u8d56\uff0c\u4e0d\u4f1a\u8fdb\u884c\u81ea\u52a8\u914d\u7f6e\u7edf\u4e00\u6570\u636e\u5e93\u8fde\u63a5\u6c60");
        }
        isSpringJdbcJarImported = isSpringJdbcJarImportedTemp;
    }
}

