/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.RecordSampler;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.RemoteServiceFlowReplaySpan;
import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RecordRemoteServicePlugin {
    private static final Logger log = LoggerFactory.getLogger(RecordRemoteServicePlugin.class);
    private static final Gson gson = new Gson();
    @Resource
    private RecordSampler recordSampler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* *..Remote*ServiceImpl.*(..))")
    public Object remoteServiceJoinPoint(ProceedingJoinPoint point) throws Throwable {
        RemoteServiceFlowReplaySpan mainSpan = null;
        Object returnValue = null;
        try {
            mainSpan = this.tryTrace(point);
        }
        catch (Throwable t) {
            log.error("RecordRemoteService_tryTrace_error", t);
        }
        try {
            returnValue = point.proceed();
        }
        finally {
            this.tryStoreTrace(mainSpan, returnValue);
        }
        return returnValue;
    }

    private RemoteServiceFlowReplaySpan tryTrace(ProceedingJoinPoint point) {
        RemoteServiceFlowReplaySpan mainSpan = null;
        if (RecordContextHolder.isRecording() && this.recordSampler.isSampled()) {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            Object[] parameterValues = point.getArgs();
            FlowReplayTrace.cleanRecordEnv();
            mainSpan = RemoteServiceFlowReplaySpan.createSpan(methodSignature, parameterValues);
            FlowReplayTrace.createTrace(mainSpan);
            mainSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());
            IgnoreSubInvokesContext.unmark();
        }
        return mainSpan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStoreTrace(RemoteServiceFlowReplaySpan mainSpan, Object returnValue) {
        RecordContext context = RecordContextHolder.getRecordContext();
        if (context == null || mainSpan == null) {
            return;
        }
        try {
            JsonElement pTemp = gson.toJsonTree(returnValue);
            mainSpan.setReturnValue(JSON.parse((String)pTemp.toString()));
            FlowReplayTrace trace = FlowReplayTrace.get();
            if (trace != null) {
                context.offerTrace(trace);
            }
        }
        catch (Throwable t) {
            log.error("RecordRemoteServicePlugin_tryStoreTrace_error", t);
        }
        finally {
            FlowReplayTrace.remove();
        }
    }
}

