/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.web.bind.annotation.RequestParam;

@Endpoint(id="flow-replay-result")
public class ReplayResultMvcEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ReplayResultMvcEndpoint.class);

    @ReadOperation
    public String invoke(@RequestParam Long reportId) {
        JsonResult<Object> result;
        try {
            if (!FlowReplayUtils.isReplayEnv()) {
                throw new FlowReplayException("\u5f53\u524d\u670d\u52a1\u975e\u56de\u5f52\u4e13\u7528\u670d\u52a1\uff0c\u65e0\u6cd5\u8fdb\u884c\u56de\u5f52\u76f8\u5173\u64cd\u4f5c");
            }
            ReplayContext context = ReplayContextHolder.getReplayContext();
            if (context == null) {
                throw new FlowReplayException("\u56de\u5f52\u672a\u5f00\u59cb");
            }
            if (!reportId.equals(context.getReportId())) {
                throw new FlowReplayException("\u975e\u6cd5\u7684\u62a5\u544aID");
            }
            JSONObject replayResult = new JSONObject();
            if (!ReplayContextHolder.isReplaying() && context.getReplayResult() != null) {
                replayResult.put("isEnded", (Object)true);
                replayResult.put("result", (Object)context.getReplayResult());
            } else {
                replayResult.put("isEnded", (Object)false);
                replayResult.put("result", null);
            }
            result = JsonResult.successResult(replayResult);
        }
        catch (FlowReplayException e) {
            result = JsonResult.failedResult(e.getMessage());
        }
        catch (Exception e) {
            log.error("\u56de\u5f52\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }
}

