/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping.dubbo;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceGroupDubboRegistryFactoryWrapper
implements RegistryFactory {
    private static final Logger log = LoggerFactory.getLogger(ServiceGroupDubboRegistryFactoryWrapper.class);
    public static final String SERVICE_GROUP_KEY = "serviceGroupKey";
    private final RegistryFactory registryFactory;

    public ServiceGroupDubboRegistryFactoryWrapper(RegistryFactory registryFactory) {
        this.registryFactory = registryFactory;
    }

    public Registry getRegistry(URL url) {
        return new RegistryWrapper(this.registryFactory.getRegistry(url));
    }

    private static class RegistryWrapper
    implements Registry {
        private final Registry originRegistry;

        private URL appendProviderServiceGroupKey(URL url) {
            String side = url.getParameter("side");
            String serviceGroupKey = System.getenv("DUIBA_SERVICE_GROUP_KEY");
            if ("provider".equals(side) && StringUtils.isNotBlank((CharSequence)serviceGroupKey)) {
                url = url.addParameter(ServiceGroupDubboRegistryFactoryWrapper.SERVICE_GROUP_KEY, serviceGroupKey);
                log.warn("\u672c\u670d\u52a1\u4e3a\u3010\u670d\u52a1\u5206\u7ec4\uff08\u591a\u573a\u666f\uff09\u3011\u7684\u670d\u52a1\uff0c\u73af\u5883\u53d8\u91cf\u4e2d\u7684\u573a\u666fkey\u4e3a: {}\uff0c\u8be5\u573a\u666fkey\u5df2\u6dfb\u52a0\u5230dubbo\u63d0\u4f9b\u8005\u4e2d\u3002", (Object)serviceGroupKey);
            }
            return url;
        }

        public RegistryWrapper(Registry originRegistry) {
            this.originRegistry = originRegistry;
        }

        public URL getUrl() {
            return this.originRegistry.getUrl();
        }

        public boolean isAvailable() {
            return this.originRegistry.isAvailable();
        }

        public void destroy() {
            this.originRegistry.destroy();
        }

        public void register(URL url) {
            this.originRegistry.register(this.appendProviderServiceGroupKey(url));
        }

        public void unregister(URL url) {
            this.originRegistry.unregister(this.appendProviderServiceGroupKey(url));
        }

        public void subscribe(URL url, NotifyListener listener) {
            this.originRegistry.subscribe(url, listener);
        }

        public void unsubscribe(URL url, NotifyListener listener) {
            this.originRegistry.unsubscribe(url, listener);
        }

        public List<URL> lookup(URL url) {
            return this.originRegistry.lookup(this.appendProviderServiceGroupKey(url));
        }
    }
}

