/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.initserver;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.JarVersionUtils;
import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.ConcurrentUtils;
import cn.com.duibaboot.ext.autoconfigure.core.AsyncSpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisProperties;
import cn.com.duibaboot.ext.autoconfigure.initserver.ApplicationListenerForAsyncSpecified;
import cn.com.duibaboot.ext.autoconfigure.initserver.BeanPostProcessorOfSpecified;
import cn.com.duibaboot.ext.autoconfigure.initserver.MainContextRefreshedEventPublishApplicationRunner;
import cn.com.duibaboot.ext.autoconfigure.web.ServerStatusHolder;
import com.google.common.base.Joiner;
import com.mysql.cj.jdbc.Driver;
import io.lettuce.core.AbstractRedisAsyncCommands;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.rpc.service.EchoService;
import org.apache.hadoop.hbase.client.Result;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.dao.DataAccessException;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.hadoop.hbase.HbaseTemplate;
import org.springframework.data.hadoop.hbase.RowMapper;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import redis.clients.jedis.Jedis;

@Configuration
@AutoConfigureOrder(value=-2147483648)
public class InitServerAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(InitServerAutoConfiguration.class);
    @Value(value="${server.port}")
    private int port;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    @PostConstruct
    public void init() {
        MainApplicationContextHolder._setApplicationContext((ConfigurableApplicationContext)this.applicationContext);
        RedisProperties rp = new RedisProperties();
        try {
            BeanUtils.copy((Object)rp, RedisProperties.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u5c1d\u8bd5\u8c03\u7528BeanUtils.copy\u65b9\u6cd5\u65f6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5cglib\u5e93\u662f\u5426\u5b58\u5728jar\u5305\u51b2\u7a81\uff0c\u53ea\u4fdd\u7559cglib:cglib\u4f9d\u8d56\u5373\u53ef", e);
        }
        String wolfVersion = JarVersionUtils.getJarVersion(ConcurrentUtils.class);
        if (StringUtils.isBlank((CharSequence)wolfVersion) || !JarVersionUtils.isJarVersionEqualOrGreaterThan((String)wolfVersion, (String)"2.2.39")) {
            throw new IllegalStateException("\u68c0\u6d4b\u5230wolf\u7248\u672c\u8fc7\u4f4e\uff0c\u8bf7\u53bb\u6389\u5bf9('cn.com.duiba:wolf')\u7684\u4f9d\u8d56\uff0c\u7531spring-boot-ext\u6765\u7edf\u4e00\u7ba1\u7406wolf\u7684\u7248\u672c");
        }
        this.checkInetAddress();
        this.checkSpringDataRedisVersion();
        this.checkSpringBootVersion();
        this.checkMysqlVersion();
        this.checkFastjsonVersion();
    }

    private void checkInetAddress() {
        String[] profiles;
        for (String env : profiles = this.applicationContext.getEnvironment().getActiveProfiles()) {
            if (!"dev".equals(env)) continue;
            long s = System.currentTimeMillis();
            try {
                InetAddress.getLocalHost().getHostAddress();
                InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            long e = System.currentTimeMillis();
            if (e - s <= 500L) continue;
            throw new IllegalStateException("\u68c0\u6d4b\u5230\u83b7\u53d6host\u8d85\u65f6\uff0c\u8bf7\u914d\u7f6ehosts\uff0c\u53c2\u8003\uff1ahttp://cf.dui88.com/pages/viewpage.action?pageId=33995153");
        }
    }

    private void checkSpringDataRedisVersion() {
        boolean isRedisClassExists = false;
        try {
            Class.forName("org.springframework.data.redis.connection.RedisConnection");
            isRedisClassExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (isRedisClassExists) {
            try {
                Class.forName("org.springframework.data.redis.core.types.Expiration");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("\u68c0\u6d4b\u5230spring-data-redis\u7248\u672c\u8fc7\u4f4e\uff0c\u8bf7\u53bb\u6389\u5bf9spring-data-redis\u7684\u7248\u672c\u53f7\u6307\u5b9a\uff0c\u7531spring-boot-ext\u6765\u7edf\u4e00\u7ba1\u7406spring-data-redis\u7684\u7248\u672c");
            }
        }
    }

    private void checkFastjsonVersion() {
        boolean isFastJsonClassExists = false;
        try {
            Class.forName("com.alibaba.fastjson.JSON");
            isFastJsonClassExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (isFastJsonClassExists && !"1.2.70".contains(".sec") && !JarVersionUtils.isJarVersionEqualOrGreaterThan((String)"1.2.70", (String)"1.2.69")) {
            throw new IllegalStateException("\u68c0\u6d4b\u5230fastjson\u7248\u672c\u8fc7\u4f4e\uff0c\u5efa\u8bae\u53bb\u6389\u5bf9fastjson\u7684\u7248\u672c\u53f7\u6307\u5b9a\uff0c\u7531spring-boot-ext\u6765\u7edf\u4e00\u7ba1\u7406fastjson\u7684\u7248\u672c");
        }
    }

    private void checkSpringBootVersion() {
        if ("1.5.19.RELEASE".equals(SpringBootVersion.getVersion())) {
            throw new IllegalStateException("\u68c0\u6d4b\u5230\u5f53\u524d\u9879\u76ee\u4f7f\u7528\u7684spring-boot\u7248\u672c\u4e3a1.5.19.RELEASE\uff0c\u8be5\u7248\u672c\u5f15\u5165\u7684jedis\u7248\u672c\u5b58\u5728\u4e25\u91cd\u95ee\u9898\uff0c\u4f1a\u5bfc\u81f4redis\u8fde\u63a5\u6cc4\u9732\uff0c\u8bf7\u52ff\u4f7f\u7528\u8be5\u7248\u672c!");
        }
        Class<?> jedisClass = null;
        try {
            jedisClass = Class.forName("redis.clients.jedis.Jedis");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (jedisClass != null && "2.9.1".equals(JarVersionUtils.getJedisVersion())) {
            throw new IllegalStateException("\u68c0\u6d4b\u5230\u5f53\u524d\u9879\u76ee\u4f7f\u7528\u7684jedis\u7248\u672c\u4e3a2.9.1\uff0c\u8be5jedis\u7248\u672c\u5b58\u5728\u4e25\u91cd\u95ee\u9898\uff0c\u4f1a\u5bfc\u81f4redis\u8fde\u63a5\u6cc4\u9732\uff0c\u8bf7\u52ff\u4f7f\u7528\u8be5\u7248\u672c!");
        }
    }

    private void checkMysqlVersion() {
        Class<?> mysqlDriverClass = null;
        try {
            mysqlDriverClass = Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (mysqlDriverClass != null) {
            String version;
            Package pkg = Driver.class.getPackage();
            String string = version = pkg != null ? pkg.getImplementationVersion() : null;
            if (!StringUtils.isBlank((CharSequence)version) && !JarVersionUtils.isJarVersionEqualOrGreaterThan((String)version, (String)"5.1.45")) {
                throw new IllegalStateException("\u68c0\u6d4b\u5230\u5f53\u524d\u9879\u76ee\u4f7f\u7528\u7684 mysql-connector-java \u7248\u672c\u4e3a" + version + "\uff0c\u8bf7\u5347\u7ea7\u52305.1.45\u6216\u4ee5\u4e0a\u7248\u672c(\u5efa\u8bae\u53bb\u6389\u5bf9mysql-connector-java\u7684\u7248\u672c\u53f7\u6307\u5b9a\uff0c\u7531spring-boot-ext\u6765\u7edf\u4e00\u7ba1\u7406mysql-connector-java\u7684\u7248\u672c)!");
            }
        }
    }

    @Bean
    public ApplicationRunner mainContextRefreshedEventPublishApplicationRunner() {
        return new MainContextRefreshedEventPublishApplicationRunner();
    }

    @EventListener(value={MainContextRefreshedEvent.class})
    public void onMainContextRefreshed() {
        this.checkFilters();
    }

    private void checkFilters() {
        try {
            Class.forName("javax.servlet.Filter");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Map filtersMap = null;
        Map filterRegistrationBeanMap = null;
        try {
            filtersMap = this.applicationContext.getBeansOfType(Filter.class);
        }
        catch (BeansException e) {
            logger.warn("", (Throwable)e);
        }
        try {
            filterRegistrationBeanMap = this.applicationContext.getBeansOfType(FilterRegistrationBean.class);
        }
        catch (BeansException e) {
            logger.warn("", (Throwable)e);
        }
        ArrayList<Object> allFilters = new ArrayList<Object>();
        if (filtersMap != null) {
            allFilters.addAll(filtersMap.values());
        }
        if (filterRegistrationBeanMap != null && !filterRegistrationBeanMap.isEmpty()) {
            for (FilterRegistrationBean b : filterRegistrationBeanMap.values()) {
                allFilters.add(b.getFilter());
            }
        }
        ArrayList<String> unexpectedFilterClassNames = new ArrayList<String>();
        for (Filter filter2 : allFilters) {
            String className = filter2.getClass().getName();
            if (className.startsWith("org.springframework.") || className.startsWith("cn.com.duibaboot.") || className.startsWith("brave.servlet.") || className.startsWith("com.sun.jersey")) continue;
            unexpectedFilterClassNames.add(className);
        }
        if (!unexpectedFilterClassNames.isEmpty() && logger.isWarnEnabled()) {
            logger.warn("\u68c0\u6d4b\u5230\u60a8\u7684\u9879\u76ee\u4e2d\u4f7f\u7528\u4e86Filter\uff0c\u8bf7\u5c3d\u91cf\u4f7f\u7528HandlerInterceptor\u6765\u4ee3\u66ffFilter,\u4ee5\u907f\u514d\u7ebf\u4e0a\u538b\u6d4b\u51fa\u73b0\u95ee\u9898\uff0c\u907f\u514d\u62e6\u622aspring-boot-starter-actuator\u7684endpoint;\u60a8\u4f7f\u7528\u5230\u7684Filter\u7c7b\u6709\u5982\u4e0b\u8fd9\u4e9b: {}", (Object)Joiner.on((String)",").join(unexpectedFilterClassNames));
        }
    }

    @Bean
    public static BeanPostProcessorOfSpecified specifiedBeanPostProcessor() {
        return new BeanPostProcessorOfSpecified();
    }

    @Bean
    public ApplicationListenerForAsyncSpecified asyncSpecifiedBeanPostProcessorConfigurer(BeanPostProcessorOfSpecified specifiedBeanPostProcessor) {
        return new ApplicationListenerForAsyncSpecified(specifiedBeanPostProcessor.getAsyncProcessor2BeansMap());
    }

    @EventListener(value={MainContextRefreshedEvent.class})
    @Order(value=0x7FFFFFFF)
    public void onMainContextRefreshed(MainContextRefreshedEvent event) {
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(200).setSocketTimeout(5000).setConnectionRequestTimeout(100).build()).setMaxConnPerRoute(1).setMaxConnTotal(1).setUserAgent("DuibaBootInit").disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().evictExpiredConnections().build();){
            HttpGet monitorCheckReq = new HttpGet("http://localhost:" + this.port + "/monitor/check");
            CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)monitorCheckReq);
            resp.close();
        }
        catch (IOException e) {
            logger.warn("init self failed", (Throwable)e);
        }
        ServerStatusHolder.setInService(true);
    }

    @Configuration
    @ConditionalOnClass(value={HbaseTemplate.class})
    public static class HbasePostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor hbasePostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<HbaseTemplate>(){

                @Override
                public Class<HbaseTemplate> getBeanType() {
                    return HbaseTemplate.class;
                }

                @Override
                public void postProcessAfterInitialization(HbaseTemplate hbaseTemplate, String beanName) {
                    try {
                        hbaseTemplate.get("hbase:meta", "1", (RowMapper)new RowMapper<String>(){

                            public String mapRow(Result result, int rowNum) throws Exception {
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.info("\u542f\u52a8\u65f6\u9884\u70edhbase\u5931\u8d25", (Throwable)e);
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={MongoOperations.class})
    public static class MongoDbPostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor mongoDbPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<MongoOperations>(){

                @Override
                public Class<MongoOperations> getBeanType() {
                    return MongoOperations.class;
                }

                @Override
                public void postProcessAfterInitialization(MongoOperations mongoOperations, String beanName) {
                    try {
                        mongoOperations.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)"1")), String.class, "test_collection");
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={ElasticsearchOperations.class})
    public static class ElasticSearchPostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor elasticSearchPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<ElasticsearchOperations>(){

                @Override
                public Class<ElasticsearchOperations> getBeanType() {
                    return ElasticsearchOperations.class;
                }

                @Override
                public void postProcessAfterInitialization(ElasticsearchOperations elasticsearchOperations, String beanName) {
                    elasticsearchOperations.indexExists("justForTest");
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisTemplate.class})
    public static class RedisPostProcessorConfiguration {
        private static final Class JEDIS_CONN_CLASS;
        private static final Class LETTUCE_CONN_CLASS;

        @Bean
        public AsyncSpecifiedBeanPostProcessor redisPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<RedisTemplate>(){

                @Override
                public Class<RedisTemplate> getBeanType() {
                    return RedisTemplate.class;
                }

                @Override
                public void postProcessAfterInitialization(RedisTemplate redisTemplate, String beanName) {
                    try {
                        redisTemplate.execute(new RedisCallback(){

                            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                                Object obj = connection.getNativeConnection();
                                if (JEDIS_CONN_CLASS != null && JEDIS_CONN_CLASS.isAssignableFrom(obj.getClass())) {
                                    Jedis jedis = (Jedis)obj;
                                    return jedis.get("justForInitTest");
                                }
                                if (LETTUCE_CONN_CLASS != null && LETTUCE_CONN_CLASS.isAssignableFrom(obj.getClass())) {
                                    StatefulRedisConnection s;
                                    RedisClusterAsyncCommands redisAsyncConn = (RedisClusterAsyncCommands)obj;
                                    StatefulConnection redisConnection = ((AbstractRedisAsyncCommands)redisAsyncConn).getConnection();
                                    if (redisConnection instanceof StatefulRedisConnection) {
                                        s = (StatefulRedisConnection)redisConnection;
                                        RedisCommands redisCommands = s.sync();
                                        redisCommands.get((Object)"justForInitTest".getBytes());
                                    } else if (redisConnection instanceof StatefulRedisClusterConnection) {
                                        s = (StatefulRedisClusterConnection)redisConnection;
                                        RedisAdvancedClusterCommands redisCommands = s.sync();
                                        redisCommands.get((Object)"justForInitTest".getBytes());
                                    }
                                    try {
                                        return redisAsyncConn.get((Object)"justForInitTest".getBytes()).get(1000L, TimeUnit.SECONDS);
                                    }
                                    catch (Exception e) {
                                        throw new RedisConnectionFailureException("", (Throwable)e);
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        if (redisTemplate.getConnectionFactory() instanceof JedisConnectionFactory) {
                            JedisConnectionFactory cf = (JedisConnectionFactory)redisTemplate.getConnectionFactory();
                            logger.error("Init redisTemplate(beanName:{}) failed, currentHost:{}, port:{}", new Object[]{beanName, cf.getHostName(), cf.getPort(), e});
                        }
                        if (redisTemplate.getConnectionFactory() instanceof LettuceConnectionFactory) {
                            LettuceConnectionFactory cf = (LettuceConnectionFactory)redisTemplate.getConnectionFactory();
                            logger.error("Init redisTemplate(beanName:{}) failed, currentHost:{}, port:{}", new Object[]{beanName, cf.getHostName(), cf.getPort(), e});
                        }
                        throw e;
                    }
                }
            };
        }

        static {
            Class<?> lettuceConnClass = null;
            try {
                lettuceConnClass = Class.forName("io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            LETTUCE_CONN_CLASS = lettuceConnClass;
            Class<?> jedisConnClass = null;
            try {
                jedisConnClass = Class.forName("redis.clients.jedis.Jedis");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            JEDIS_CONN_CLASS = jedisConnClass;
        }
    }

    @Configuration
    @ConditionalOnClass(value={CannotGetJdbcConnectionException.class, DataSource.class})
    public static class DataSourcePostInitProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor dataSourceInitPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<DataSource>(){

                @Override
                public Class<DataSource> getBeanType() {
                    return DataSource.class;
                }

                @Override
                public void postProcessAfterInitialization(DataSource dataSource, String beanName) {
                    Connection conn = null;
                    try {
                        conn = dataSource.getConnection();
                    }
                    catch (SQLException e) {
                        throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", e);
                    }
                    finally {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={EchoService.class})
    public static class DubboPostProcessorConfiguration {
        @Bean
        public AsyncSpecifiedBeanPostProcessor dubboPostProcessorConfigurer() {
            return new AsyncSpecifiedBeanPostProcessor<EchoService>(){

                @Override
                public Class<EchoService> getBeanType() {
                    return EchoService.class;
                }

                @Override
                public void postProcessAfterInitialization(EchoService echoService, String beanName) {
                    try {
                        echoService.$echo((Object)"OK");
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={ServletRegistrationBean.class})
    public static class SpringServletInitConfiguration {
        @Bean
        public static SpecifiedBeanPostProcessor webPostProcessorConfigurer() {
            return new SpecifiedBeanPostProcessor<ServletRegistrationBean>(){

                public int getOrder() {
                    return 0;
                }

                @Override
                public Class<ServletRegistrationBean> getBeanType() {
                    return ServletRegistrationBean.class;
                }

                @Override
                public Object postProcessBeforeInitialization(ServletRegistrationBean bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(ServletRegistrationBean bean, String beanName) throws BeansException {
                    if (bean.getServletName().equalsIgnoreCase("dispatcherServlet")) {
                        bean.setLoadOnStartup(1);
                    }
                    return bean;
                }
            };
        }
    }
}

