/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.limiter;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duibaboot.ext.autoconfigure.limiter.RateLimiterException;
import cn.com.duibaboot.ext.autoconfigure.limiter.ServerLimiterAutoConfiguration;
import com.google.common.util.concurrent.RateLimiter;
import com.netflix.concurrency.limits.Limiter;
import feign.Feign;
import java.lang.reflect.Method;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Configuration
@ConditionalOnClass(value={Servlet.class, FeignClient.class})
@ConditionalOnWebApplication
public class SpringRpcLimterInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SpringRpcLimterInterceptor.class);
    private static final ThreadLocal<Limiter.Listener> localLimiter = new ThreadLocal();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod) || RequestUtils.getRequestPath((HttpServletRequest)request).equals("/error") && request.getAttribute("javax.servlet.forward.request_uri") != null) {
            return true;
        }
        if (!"true".equals(request.getHeader("X-Rpc"))) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        Class<?> handlerClass = method.getDeclaringClass();
        if (handlerClass.equals(BasicErrorController.class)) {
            return true;
        }
        Class<?> feignClientClass = null;
        for (Class<?> clazz : handlerClass.getInterfaces()) {
            if (!clazz.isAnnotationPresent(AdvancedFeignClient.class) && !clazz.isAnnotationPresent(FeignClient.class)) continue;
            feignClientClass = clazz;
            break;
        }
        if (feignClientClass == null) {
            log.warn("[NOTIFYME]can not find any interface of class:[{}] which annotated with @FeignClient or @AdvancedFeignClient, will not limit", (Object)handlerClass.getName());
            return true;
        }
        if ((method = ReflectionUtils.findMethod(feignClientClass, (String)method.getName(), (Class[])method.getParameterTypes())) == null) {
            log.warn("[NOTIFYME]feign method is null");
            return true;
        }
        String feignUniqKey = Feign.configKey(feignClientClass, (Method)method);
        Object limiter = ServerLimiterAutoConfiguration.getServerLimitRule(feignUniqKey);
        if (limiter == null) {
            return true;
        }
        if (limiter instanceof RateLimiter) {
            RateLimiter rateLimiter = (RateLimiter)limiter;
            if (!rateLimiter.tryAcquire()) {
                throw new RateLimiterException();
            }
            return true;
        }
        Limiter vegasLimiter = (Limiter)limiter;
        Limiter.Listener listener = (Limiter.Listener)vegasLimiter.acquire(null).orElseThrow(RateLimiterException::new);
        localLimiter.set(listener);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Limiter.Listener listener = localLimiter.get();
        if (listener == null) {
            return;
        }
        if (ex == null) {
            listener.onSuccess();
        } else {
            listener.onIgnore();
        }
        localLimiter.remove();
    }
}

