/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.security;

import cn.com.duibaboot.ext.autoconfigure.security.DefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.security.DevEnvSecurityPreprocessor;
import cn.com.duibaboot.ext.autoconfigure.security.SecurityCheckSandbox;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;

public class SecurityFilter
implements Filter {
    private Multimap<SimpleMediaType, DefensivePolicy> defensivePolicyMap = ArrayListMultimap.create();
    @Autowired
    private List<DefensivePolicy> defensivePolicyList;
    @Autowired(required=false)
    private DevEnvSecurityPreprocessor devEnvSecurityPreprocessor;

    public void init(FilterConfig filterConfig) {
    }

    @PostConstruct
    public void initialize() {
        for (DefensivePolicy policy : this.defensivePolicyList) {
            Set<MediaType> mediaTypes = policy.getMediaTypes();
            if (mediaTypes.contains(MediaType.ALL)) {
                this.defensivePolicyMap.put((Object)new SimpleMediaType(MediaType.ALL), (Object)policy);
                continue;
            }
            for (MediaType mediaType : mediaTypes) {
                this.defensivePolicyMap.put((Object)new SimpleMediaType(mediaType), (Object)policy);
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        ArrayList policyList = Lists.newArrayList();
        policyList.addAll(this.defensivePolicyMap.get((Object)new SimpleMediaType(MediaType.ALL)));
        String contentType = request.getHeader("Content-Type");
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            MediaType mediaType = MediaType.parseMediaType((String)contentType);
            policyList.addAll(this.defensivePolicyMap.get((Object)new SimpleMediaType(mediaType)));
        }
        if (this.devEnvSecurityPreprocessor != null) {
            this.devEnvSecurityPreprocessor.preprocessor(request, response);
        }
        SecurityCheckSandbox sandbox = new SecurityCheckSandbox(request, response, policyList);
        sandbox.doCheck();
        sandbox.doFilter(filterChain);
    }

    public void destroy() {
        this.defensivePolicyMap.clear();
    }

    class SimpleMediaType {
        private final String type;
        private final String subtype;

        SimpleMediaType(MediaType mediaType) {
            this.type = mediaType.getType();
            this.subtype = mediaType.getSubtype();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleMediaType that = (SimpleMediaType)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.subtype, that.subtype);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.subtype);
        }
    }
}

