package cn.com.duibaboot.ext.autoconfigure.flowreplay.record;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.event.RecordEndEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * 构造录制结果，并且把录制结果回填到 RecordContext 中
 * Created by guoyanfei .
 * 2019-02-25 .
 */
@Slf4j
public class RecordResultBuilder {

    @Resource
    private FlowReplayFileComponent flowReplayFileComponent;

    /**
     * 监听"录制结束"事件
     * @param event
     * @throws IOException
     */
    @EventListener(RecordEndEvent.class)
    public void recordEndEventListener(RecordEndEvent event) {
        new Thread(new Runnable() {

            @Override
            public void run() {
                RecordContext context = RecordContextHolder.getRecordContext();
                if (context == null) {
                    return;
                }

                String usecaseSetOssPath = null;
                String recordDetailOssPath = null;
                try {
                    usecaseSetOssPath = flowReplayFileComponent.upload(FlowReplayConstants.LOCAL_RECORD_FILEPATH);
                    recordDetailOssPath = flowReplayFileComponent.upload(FlowReplayConstants.LOCAL_RECORD_DETAIL_FILEPATH);
                } catch (IOException e) {
                    log.error("用例集/录制详情_文件操作异常", e);
                }

                try {
                    Thread.sleep(6000); // 日志打印可能有5秒左右延迟，等日志打完之后再开始上传
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }

                String applicationLogUrl = null;
                try {
                    applicationLogUrl = flowReplayFileComponent.upload(FlowReplayConstants.LOCAL_RECORD_LOG_PATH);
                    flowReplayFileComponent.clearFile(FlowReplayConstants.LOCAL_RECORD_LOG_PATH + "/record.log");
                } catch (IOException e) {
                    log.error("上传应用日志_文件操作异常_usecaseSetId_{}", context.getUsecaseSetId(), e);
                }

                // 清空引流回归文件目录，但是不清日志目录
                FlowReplayFileComponent.removeDir();

                RecordResult result = new RecordResult();
                result.setUsecaseSetId(context.getUsecaseSetId());
                result.setNormal(event.isNormal());
                result.setMessage(event.getMessage());
                result.setOssPath(usecaseSetOssPath);
                result.setFileSize(context.getCurrentFileSize());
                result.setRecordDetailPath(recordDetailOssPath);
                result.setApplicationLogUrl(applicationLogUrl);
                result.setStartTime(context.getStartTime());
                result.setEndTime(context.getEndTime());
                context.setRecordResult(result);
            }
        }, "DBThread-Record-Upload").start();

    }

}
