package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;

/**
 * caffeine缓存类型的span
 * Created by guoyanfei .
 * 2019-04-15 .
 */
public class CaffeineCacheFlowReplaySpan extends StandardSpan {

    private static final long serialVersionUID = 4625240016356029449L;

    private boolean guavaOptionalReturnValue = false;

    private boolean javaOptionalReturnValue = false;

    @Override
    public SpanType getSpanType() {
        return SpanType.CAFFEINE_CACHE;
    }

    /**
     * 创建span
     * @param methodName
     * @param allArguments
     * @param argumentsTypes
     * @param ret
     * @return
     */
    public static CaffeineCacheFlowReplaySpan createSpan(String methodName, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        String[] parameterTypes = null;
        Class<?>[] argumentsTypesTemp = customizeArgumentsTypes(methodName, argumentsTypes);
        if (argumentsTypesTemp.length > 0) {
            parameterTypes = new String[argumentsTypesTemp.length];
            for (int i = 0; i < argumentsTypesTemp.length; i++) {
                parameterTypes[i] = argumentsTypesTemp[i].getName();
            }
        }
        CaffeineCacheFlowReplaySpan span = new CaffeineCacheFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.setMethodName(methodName);
        span.setParameterTypes(parameterTypes);
        span.setParameterValues(customizeParameterValues(methodName, allArguments));
        span.setRet(ret);
        return span;
    }

    public static Class<?>[] customizeArgumentsTypes(String methodName, Class<?>[] argumentsTypes) {
        if ("get".equals(methodName)) {
            return new Class<?>[] { argumentsTypes[0] };
        }
        return argumentsTypes;
    }

    public static Object[] customizeParameterValues(String methodName, Object[] parameterValues) {
        if ("get".equals(methodName)) {
            return new Object[] { parameterValues[0] };
        }
        return parameterValues;
    }

    @Override
    public Object getReturnValue() {
        Object ret = super.getReturnValue();
        if (javaOptionalReturnValue) {
            return java.util.Optional.ofNullable(ret);
        }
        if (guavaOptionalReturnValue) {
            return com.google.common.base.Optional.fromNullable(ret);
        }
        return ret;
    }

    public void setRet(Object ret) {
        if (ret == null) {
            return;
        }
        Object retTemp = null;
        if (ret instanceof java.util.Optional) {
            java.util.Optional optional = (java.util.Optional) ret;
            if (optional.isPresent()) {
                retTemp = optional.get();
            }
            this.javaOptionalReturnValue = true;
        } else if (ret instanceof com.google.common.base.Optional) {
            com.google.common.base.Optional optional = (com.google.common.base.Optional) ret;
            if (optional.isPresent()) {
                retTemp = optional.get();
            }
            this.guavaOptionalReturnValue = true;
        } else {
            retTemp = ret;
        }
        this.setReturnType(ret.getClass().getName());
        this.setReturnValue(retTemp);
    }

}
