package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-23 10:19
 * @descript:
 * @version: 1.0
 */
@Data
public class CacheChangeRecord implements Serializable {

    private static final long serialVersionUID = -6121167261394012138L;

    private String cacheName;

    /**
     * 缓存的key
     */
    private Object key;

    /**
     * 缓存的值，未录制前是原值，录制保存时会json序列化
     *
     */
    private Object value;

    private Date expireDate;

    private int expireType;

    private Integer builderHashcode;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CacheChangeRecord that = (CacheChangeRecord) o;
        return expireType == that.expireType && Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, expireDate, expireType);
    }

    public CacheChangeRecord buildSerializableObj() {
        this.setKey(null);
        this.setCacheName(null);
        this.setBuilderHashcode(null);
        this.setValue(JSON.toJSONString(this.getValue()));
        return this;
    }
}
