package cn.com.duibaboot.ext.autoconfigure.monitor.jvm;

import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * jvm监控配置
 * Created by guoyanfei .
 * 2021/6/9 .
 */
@ConfigurationProperties("duiba.jvm.monitor")
public class DuibaJvmMonitorProperties {

    private static final Map<Integer, Integer> DEFAULT_FGC_RULE = new HashMap<>();
    private static final Map<Integer, Integer> DEFAULT_FGCT_RULE = new HashMap<>();
    private static final Map<Integer, Integer> DEFAULT_YGC_RULE = new HashMap<>();
    private static final Map<Integer, Integer> DEFAULT_YGCT_RULE = new HashMap<>();

    static {
        // 10分钟5次
        DEFAULT_FGC_RULE.put(10, 5);

        // 10分钟5秒
        DEFAULT_FGCT_RULE.put(10, 5000);

        // 1分钟20次
        DEFAULT_YGC_RULE.put(1, 20);

        // 1分钟2秒
        DEFAULT_YGCT_RULE.put(1, 2000);
    }

    /**
     * FGC次数
     * key: 分钟数
     * value: 次数
     */
    private Map<Integer, Integer> fgcRule = DEFAULT_FGC_RULE;

    /**
     * FGCT时长
     * key: 分钟数
     * value: 时长(ms)
     */
    private Map<Integer, Integer> fgctRule = DEFAULT_FGCT_RULE;

    /**
     * YGC次数
     * key: 分钟数
     * value: 次数
     */
    private Map<Integer, Integer> ygcRule = DEFAULT_YGC_RULE;

    /**
     * YGCT时长
     * key: 分钟数
     * value: 时长(ms)
     */
    private Map<Integer, Integer> ygctRule = DEFAULT_YGCT_RULE;

    /**
     * 开启ThreadDump
     */
    private boolean enableThreadDump = true;

    public void setFgcRule(String fgcRule) {
        if (StringUtils.isBlank(fgcRule)) {
            this.fgcRule = Collections.emptyMap();
        } else {
            this.fgcRule = JSON.parseObject(fgcRule, Map.class);
        }
    }

    public void setFgctRule(String fgctRule) {
        if (StringUtils.isBlank(fgctRule)) {
            this.fgctRule = Collections.emptyMap();
        } else {
            this.fgctRule = JSON.parseObject(fgctRule, Map.class);
        }
    }

    public void setYgcRule(String ygcRule) {
        if (StringUtils.isBlank(ygcRule)) {
            this.ygcRule = Collections.emptyMap();
        } else {
            this.ygcRule = JSON.parseObject(ygcRule, Map.class);
        }
    }

    public void setYgctRule(String ygctRule) {
        if (StringUtils.isBlank(ygctRule)) {
            this.ygctRule = Collections.emptyMap();
        } else {
            this.ygctRule = JSON.parseObject(ygctRule, Map.class);
        }
    }

    public void setEnableThreadDump(boolean enableThreadDump) {
        this.enableThreadDump = enableThreadDump;
    }

    public Map<Integer, Integer> getFgcRule() {
        return fgcRule;
    }

    public Map<Integer, Integer> getFgctRule() {
        return fgctRule;
    }

    public Map<Integer, Integer> getYgcRule() {
        return ygcRule;
    }

    public Map<Integer, Integer> getYgctRule() {
        return ygctRule;
    }

    public boolean isEnableThreadDump() {
        return enableThreadDump;
    }
}
