package cn.com.duibaboot.ext.autoconfigure.security;

import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.CsrfDefensivePolicy;
import org.springframework.web.util.UrlPathHelper;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.regex.Pattern;

/**
 * 开发测试某些环境下，不希望安全规则被催发，结合各个安全防御策略开的后门实现放行
 */
public class DevEnvSecurityPreprocessor {

    public static final String DEFAULT_SKIP_PATTERN =
            "/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream";

    private final UrlPathHelper urlPathHelper = new UrlPathHelper();

    private Pattern skipPattern = Pattern.compile(DEFAULT_SKIP_PATTERN);

    public static final String CSRF_OFF = "csrf_off";

    /**
     * 预处理
     * @param request 请求体
     * @param response 响应
     */
    public void preprocessor(HttpServletRequest request,HttpServletResponse response){

        String uri = this.urlPathHelper.getPathWithinApplication(request);
        boolean skip = this.skipPattern.matcher(uri).matches();

        if(skip || Boolean.parseBoolean(request.getParameter(CSRF_OFF))){
            request.setAttribute(CsrfDefensivePolicy.CSRF_PASS_MARK,true);
        }
    }

}
