package cn.com.duibaboot.ext.autoconfigure.cat;

import brave.ErrorParser;
import brave.Span;
import brave.Tracer;
import cn.com.duiba.boot.perftest.PerfTestContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class SleuthJestElasticSearchPlugin {

    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    /**
     * 拦截execute接口，记录执行耗时
     *
     * @param joinPoint
     * @return
     * @throws Throwable
     */
    @Around("execution(* io.searchbox.client.JestClient.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();

        Span curSpan = tracer.currentSpan();
        if(curSpan == null){
            return joinPoint.proceed();
        }

        if (!"execute".equals(methodName) && !"executeAsync".equals(methodName)) {
            return joinPoint.proceed();
        } else {
            Span span = tracer.nextSpan().name("elasticsearch:/"+methodName).kind(Span.Kind.CLIENT)
                    .remoteServiceName("elasticsearch")
                    .start();
            try {
                if(!span.isNoop()) {
                    span.tag("elasticsearch.class_method", "JestClient." + methodName);
                    span.tag("lc", "Jest");//本地组件名
                    span.tag("isPerfTest", Boolean.toString(PerfTestContext.isCurrentInPerfTestMode()));
                    span.tag("thread", Thread.currentThread().getName());
                }

                return joinPoint.proceed();
            } catch(Exception e){
                errorParser.error(e, span);
                throw e;
            } finally {
                span.finish();
            }
        }
    }

}
