package cn.com.duibaboot.ext.autoconfigure.cat.annotation;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

/**
 * 加入aop，对CatTransaction注解监控执行耗时
 */
@Aspect
public class CatTransactionAspect {

	@Around("@annotation(cn.com.duibaboot.ext.autoconfigure.cat.annotation.CatTransaction)")
	public Object catTransactionAspect(ProceedingJoinPoint joinPoint) throws Throwable{
		MethodSignature signature = (MethodSignature) joinPoint.getSignature();
		CatTransaction catTransaction = signature.getMethod().getAnnotation(CatTransaction.class);
		if(catTransaction == null){
			return joinPoint.proceed();
		}
//		String methodName = signature.getMethod().getName();

		return CatUtils.executeInCatTransaction(() -> joinPoint.proceed(), catTransaction.type(), catTransaction.name());
	}

}
