package cn.com.duibaboot.ext.autoconfigure.monitor.jvm.alert;

import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.DuibaJvmMonitorProperties;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.JstatPoint;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.JvmAlertComponent;
import org.apache.commons.lang3.tuple.Pair;

import javax.annotation.Resource;
import java.util.Map;

public class YGCAlerter extends GcAlerter {

    @Resource
    private DuibaJvmMonitorProperties duibaJvmMonitorProperties;

    @Resource
    private JvmAlertComponent jvmAlertComponent;

    @Override
    public Map<Integer, Integer> getRule() {
        return duibaJvmMonitorProperties.getYgcRule();
    }

    @Override
    public int compute(Pair<JstatPoint, JstatPoint> pointPair) {
        JstatPoint left = pointPair.getLeft();
        JstatPoint right = pointPair.getRight();
        return right.getYgc() - left.getYgc();
    }

    @Override
    public void alert(int ruleMinutes, int ruleValue, int currentValue) {
        jvmAlertComponent.doGcAlert(ruleMinutes, ruleValue + "次", currentValue + "次", "YGC过于频繁");
    }
}
