package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Created by wenqi.huang on 2017/04/18.
 */
@ConfigurationProperties(prefix = "duiba.rocketmq")
public class RocketMqProperties {
    /**
     * Producer属性
     */
    private ProducerProperties producer;
    /**
     * Consumer属性
     */
    private ConsumerProperties consumer;
    /**
     * 额外的Consumer属性,如果需要配置多个consumer，请配置在这里,目前最多支持3个额外的consumer
     */
    private ConsumerProperties[] extraConsumer;
    /**
     * RocketMQ nameSrv地址
     */
    private String nameSrvAddr;

    public ProducerProperties getProducer() {
        return producer;
    }

    public void setProducer(ProducerProperties producer) {
        this.producer = producer;
    }

    public ConsumerProperties getConsumer() {
        return consumer;
    }

    public void setConsumer(ConsumerProperties consumer) {
        this.consumer = consumer;
    }

    public String getNameSrvAddr() {
        if(nameSrvAddr != null && nameSrvAddr.trim().equals("")){
            return null;
        }
        return nameSrvAddr;
    }

    public void setNameSrvAddr(String nameSrvAddr) {
        this.nameSrvAddr = nameSrvAddr;
    }

    public ConsumerProperties[] getExtraConsumer() {
        return extraConsumer;
    }

    public void setExtraConsumer(ConsumerProperties[] extraConsumer) {
        this.extraConsumer = extraConsumer;
    }

    public static class ProducerProperties{
        /**
         * 是否启用RocketMQ生产者
         */
        private Boolean enable = false;

        /**
         * 即ProducerId
         */
        private String group;

        /**
         * 发送超时时间，单位：ms，默认：400ms
         */
        private Integer sendMsgTimeoutMillis = 400;

        public Boolean getEnable() {
            return enable;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public String getGroup() {
            return group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public Integer getSendMsgTimeoutMillis() {
            return sendMsgTimeoutMillis;
        }

        public void setSendMsgTimeoutMillis(Integer sendMsgTimeoutMillis) {
            this.sendMsgTimeoutMillis = sendMsgTimeoutMillis;
        }
    }
    public static class ConsumerProperties{
        /**
         * 是否启用RocketMQ消费者
         */
        private Boolean enable = false;

        /**
         * 即ConsumerId
         */
        private String group;

        /**
         * 需要订阅的topic，多个用英文半角逗号隔开
         */
        private String topics;

        /**
         * 消费模型：CLUSTERING/BROADCASTING,分别表示集群消费模型/广播消费模型,默认是集群消费模型<br/>
         * 集群消费模式是指某个topic、group下的一个消息只会被集群中的随机一台机器消费；<br/>
         * 广播消费模式是指某个topic、group下的一个消息会被集群中的每一台机器消费。<br/>
         * 这个模式参数非常重要，会对当前consumer订阅的所有topic都生效，所以如果一开始确定了某种消费模式，修改时请务必谨慎。
         */
        private String messageModel = MessageModel.CLUSTERING.getModeCN();

        /**
         * 消息消费的最大重试次数，默认16
         */
        private Integer maxReconsumeTimes = 16;
        /**
         * 消费线程数量, 不设置时线程池最小大小为20，最大为64。如果你设置了，则最小值是你设的值，最大值是max(你设置的值, 64),一般默认即可
         */
        private Integer consumeThreadNums = 0;

        /**
         * MessageListener监听器每次接受本地队列的消息是多少条(默认1条，注意这个配置不能控制每次从rocketmq服务器拉取的条数）
         */
        private Integer consumeMessageBatchMaxSize = 1;

        public Integer getConsumeMessageBatchMaxSize() {
            return consumeMessageBatchMaxSize;
        }

        public void setConsumeMessageBatchMaxSize(Integer consumeMessageBatchMaxSize) {
            this.consumeMessageBatchMaxSize = consumeMessageBatchMaxSize;
        }

        public Boolean getEnable() {
            return enable;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public String getGroup() {
            return group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public Integer getMaxReconsumeTimes() {
            return maxReconsumeTimes;
        }

        public void setMaxReconsumeTimes(Integer maxReconsumeTimes) {
            this.maxReconsumeTimes = maxReconsumeTimes;
        }

        public Integer getConsumeThreadNums() {
            return consumeThreadNums;
        }

        public void setConsumeThreadNums(Integer consumeThreadNums) {
            this.consumeThreadNums = consumeThreadNums;
        }

        public String getTopics() {
            return topics;
        }

        public void setTopics(String topics) {
            this.topics = topics;
        }

        public String getMessageModel() {
            return messageModel;
        }

        public MessageModel getMessageModelEnum() {
            for(MessageModel m : MessageModel.values()){
                if(m.getModeCN().equals(messageModel)){
                    return m;
                }
            }

            throw new IllegalStateException("illegal messageModel of rocketmq, must be one of [CLUSTERING, BROADCASTING], but you set: " + messageModel);
        }

        public void setMessageModel(String messageModel) {
            this.messageModel = messageModel;
        }
    }
}
