package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.hadoop.hbase.client.Table;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.framework.ProxyFactory;

/**
 * apache hbase aspect
 * <p>
 * 为 'org.apache.hadoop.hbase.client.Table' 增加 MethodInterceptor, 增加cat监控，监听hbase执行耗时
 */
@Aspect
public class CatApacheHbaseConnectAspect {

    private static final String space = "Hbase";

    @Around("execution(* org.apache.hadoop.hbase.client.Connection.getTable(..))")
    public Object apacheHbaseConnectJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Table table = (Table) joinPoint.proceed();

        ProxyFactory factory = new ProxyFactory();
        factory.setTarget(table);
        factory.addAdvice(new HbaseMethodInterceptor());
        return factory.getProxy();
    }

    /**
     * {@link MethodInterceptor}
     */
    private static class HbaseMethodInterceptor implements MethodInterceptor {

        HbaseMethodInterceptor() {
        }

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            //忽略Object基类中的方法
            if (methodName.equals("toString") || methodName.equals("hashCode") || methodName.equals("equals")) {
                return invocation.proceed();
            }

            //只拦截指定方法
            if (methodName.equals("exists")
                    || methodName.equals("existsAll")
                    || methodName.equals("batch")
                    || methodName.equals("batchCallback")
                    || methodName.equals("get")
                    || methodName.equals("getScanner")
                    || methodName.equals("put")
                    || methodName.equals("checkAndPut")
                    || methodName.equals("delete")
                    || methodName.equals("checkAndDelete")
                    || methodName.equals("mutateRow")
                    || methodName.equals("append")
                    || methodName.equals("increment")
                    || methodName.equals("incrementColumnValue")) {
                return CatUtils.executeInCatTransaction(() -> invocation.proceed(), space, methodName);
            }

            return invocation.proceed();
        }

    }

}
