/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.accesslog;

import cn.com.duiba.wolf.spring.selfaware.SelfAware;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AbstractAccessLogFilter;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogFilter
extends AbstractAccessLogFilter<HttpServletRequest, HttpServletResponse>
implements Filter,
SelfAware<AccessLogFilter> {
    private static final Logger log = LoggerFactory.getLogger(AccessLogFilter.class);
    @Deprecated
    private static final ThreadLocal<HttpServletRequest> requestThreadLocal = new ThreadLocal();
    public static final String OW_HOST = "host";
    private static volatile AccessLogFilter selfBean;

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        long start = System.currentTimeMillis();
        requestThreadLocal.set(req);
        try {
            this.doBefore(req, resp);
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
        finally {
            this.doAfter(req, resp, System.currentTimeMillis() - start);
            requestThreadLocal.remove();
        }
    }

    @Deprecated
    public static void putLogCookie(String key, String value) {
        HttpServletRequest req = requestThreadLocal.get();
        selfBean.putLogCookie(req, key, value);
    }

    @Deprecated
    public static void setAppId(Long appId) {
        HttpServletRequest req = requestThreadLocal.get();
        selfBean.setAppId(req, appId);
    }

    @Deprecated
    public static void setConsumerId(Long consumerId) {
        HttpServletRequest req = requestThreadLocal.get();
        selfBean.setConsumerId(req, consumerId);
    }

    @Deprecated
    public static void putExPair(String key, Object value) {
        HttpServletRequest req = requestThreadLocal.get();
        selfBean.putExPair(req, key, value);
    }

    @Deprecated
    public static void putOverWritePair(String key, String value) {
        HttpServletRequest req = requestThreadLocal.get();
        selfBean.putOverWritePair(req, key, value);
    }

    public void destroy() {
    }

    @Override
    protected String getRequestURI(HttpServletRequest req) {
        return req.getRequestURI();
    }

    @Override
    protected String getMethod(HttpServletRequest req) {
        return req.getMethod();
    }

    @Override
    protected String getQueryString(HttpServletRequest req) {
        return req.getQueryString();
    }

    @Override
    protected String getHeader(HttpServletRequest req, String key) {
        return req.getHeader(key);
    }

    @Override
    protected String getIpAddr(HttpServletRequest req) {
        return HttpRequestUtils.getIpAddr(req);
    }

    @Override
    protected void addAttribute(HttpServletRequest req, String key, Object value) {
        req.setAttribute(key, value);
    }

    @Override
    protected Object getAttribute(HttpServletRequest req, String key) {
        return req.getAttribute(key);
    }

    @Override
    protected String getParameter(HttpServletRequest req, String key) {
        return req.getParameter(key);
    }

    @Override
    protected List<String> getParameterNames(HttpServletRequest req) {
        return EnumerationUtils.toList((Enumeration)req.getParameterNames());
    }

    @Override
    protected int getStatus(HttpServletResponse resp) {
        return resp.getStatus();
    }

    @Override
    protected void addCookie(HttpServletResponse resp, String key, String value, String domain, String path) {
        Cookie cookie = new Cookie(key, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        resp.addCookie(cookie);
    }

    @Override
    protected Map<String, String> getCookieMap(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        if (cookies != null) {
            for (Cookie c : cookies) {
                cookieMap.put(c.getName(), c.getValue());
            }
        }
        return cookieMap;
    }

    @Override
    protected void ensureSafeCall() {
        String threadName = StringUtils.defaultString((String)Thread.currentThread().getName());
        if (!(threadName.startsWith("http-nio") || threadName.startsWith("XNIO") || threadName.startsWith("qtp") || threadName.equals("main"))) {
            log.error("AccessLogFilter's methods can only be called at the servlet's thread");
        }
    }

    public void setSelf(AccessLogFilter selfBean) {
        AccessLogFilter.selfBean = selfBean;
    }
}

