/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import brave.ErrorParser;
import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class SleuthJestElasticSearchPlugin {
    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    @Around(value="execution(* io.searchbox.client.JestClient.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Span curSpan = this.tracer.currentSpan();
        if (curSpan == null) {
            return joinPoint.proceed();
        }
        if (!"execute".equals(methodName) && !"executeAsync".equals(methodName)) {
            return joinPoint.proceed();
        }
        Span span = this.tracer.nextSpan().name("elasticsearch:/" + methodName).kind(Span.Kind.CLIENT).remoteServiceName("elasticsearch").start();
        try {
            if (!span.isNoop()) {
                span.tag("elasticsearch.class_method", "JestClient." + methodName);
                span.tag("lc", "Jest");
                span.tag("thread", Thread.currentThread().getName());
            }
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            this.errorParser.error((Throwable)e, (SpanCustomizer)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

