/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;

@Order(value=-1)
public class ServiceGroupRibbonServerListFilter
implements RibbonServerListFilter {
    public List<Server> filter(List<Server> serverList, Object loadBalancerKey) {
        if (CollectionUtils.isEmpty(serverList)) {
            return serverList;
        }
        for (Server s : serverList) {
            if (s instanceof DiscoveryEnabledServer) continue;
            return serverList;
        }
        String currentServiceGroupKey = null;
        if (loadBalancerKey != null && loadBalancerKey instanceof Map) {
            Map loadBalancerInfo = (Map)loadBalancerKey;
            currentServiceGroupKey = (String)loadBalancerInfo.get("_duibaServiceGroupKey");
        }
        if (StringUtils.isBlank(currentServiceGroupKey)) {
            currentServiceGroupKey = ServiceGroupContext.getCurrentGroupKey();
        }
        ArrayList<Server> havePriorityList = new ArrayList<Server>(serverList.size());
        ArrayList<Server> noGroupKeyServerList = new ArrayList<Server>(serverList.size());
        for (Server server : serverList) {
            String serverGroupKey = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("duiba.service.group.key");
            if (this.isPriorityGroup(currentServiceGroupKey, serverGroupKey)) {
                havePriorityList.add(server);
            }
            if (!this.isNoGroup(serverGroupKey)) continue;
            noGroupKeyServerList.add(server);
        }
        if (!havePriorityList.isEmpty()) {
            return havePriorityList;
        }
        if (!noGroupKeyServerList.isEmpty()) {
            return noGroupKeyServerList;
        }
        return serverList;
    }

    private boolean isPriorityGroup(String requestGroupKey, String serverGroupKey) {
        if (StringUtils.isBlank((CharSequence)requestGroupKey) || StringUtils.isBlank((CharSequence)serverGroupKey)) {
            return false;
        }
        return StringUtils.equals((CharSequence)requestGroupKey, (CharSequence)serverGroupKey);
    }

    private boolean isNoGroup(String serverGroupKey) {
        return StringUtils.isBlank((CharSequence)serverGroupKey);
    }
}

