/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dbexec;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.dbexec.AsyncProfilerCommand;
import cn.com.duibaboot.ext.autoconfigure.dbexec.DuibaExtExecProperties;
import cn.com.duibaboot.ext.autoconfigure.dbexec.JvmIdTool;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RestControllerEndpoint(id="async-profiler")
public class AsyncProfilerEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncProfilerEndpoint.class);
    private static final String PROFILER_FILE_PATH = "/tmp/%s-%s-profiler.html";
    private static final ExecutorService es = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("async-profiler"));
    @Resource
    private DuibaExtExecProperties duibaExtExecProperties;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"}, value={"/{event}"})
    public String invoke(@PathVariable String event) {
        File profilerShFile = new File(this.duibaExtExecProperties.getAsyncProfilerCommand());
        if (!profilerShFile.exists()) {
            throw new RuntimeException("\u5f53\u524d\u5b9e\u4f8b\u6682\u4e0d\u652f\u6301\u8c03\u7528async-profiler, \u8bf7\u5c06\u57fa\u7840\u955c\u50cf\u4fee\u6539\u6210\u3010harbor.dui88.com/library/duiba-jdk8:v1.0\u3011");
        }
        if (StringUtils.isBlank((String)event)) {
            throw new RuntimeException("event \u4e0d\u80fd\u4e3a null");
        }
        AsyncProfilerCommand asyncProfilerCommand = AsyncProfilerCommand.get(event);
        if (asyncProfilerCommand == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684 event");
        }
        return this.exec(asyncProfilerCommand);
    }

    private String exec(AsyncProfilerCommand asyncProfilerCommand) {
        String profilerFilePath = String.format(PROFILER_FILE_PATH, System.currentTimeMillis(), asyncProfilerCommand.getCommandKey());
        String command = String.format(asyncProfilerCommand.getCommand(), this.duibaExtExecProperties.getAsyncProfilerCommand(), profilerFilePath, JvmIdTool.getVmId());
        es.submit(() -> {
            try {
                Runtime.getRuntime().exec(command);
            }
            catch (IOException e) {
                LOGGER.error("async-profiler exec error, command={}", (Object)command, (Object)e);
            }
        });
        return profilerFilePath;
    }
}

