/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.elasticjob;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duibaboot.ext.autoconfigure.core.EarlyClose;
import cn.com.duibaboot.ext.autoconfigure.monitor.elasticjob.ElasticjobMonitorManager;
import cn.com.duibaboot.ext.autoconfigure.monitor.elasticjob.JobExecutionTrackEvent;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import io.elasticjob.autoconfigure.eventbus.JobEventCacheStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class ElasticjobRecordCompent
extends EarlyClose {
    private static final Logger log = LoggerFactory.getLogger(ElasticjobRecordCompent.class);
    private final RestTemplate restTemplate;
    private final String currentAppName;
    private final ElasticjobMonitorManager monitorManager;
    private final HttpHeaders jsonHeader;
    private final String serverUrl;
    private final ScheduledExecutorService pushScheduled = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("duiba-elasticjob-push", true));

    public ElasticjobRecordCompent(RestTemplate restTemplate, ElasticjobMonitorManager monitorManager, String currentAppName) {
        this.restTemplate = restTemplate;
        this.monitorManager = monitorManager;
        this.currentAppName = currentAppName;
        this.jsonHeader = new HttpHeaders();
        this.jsonHeader.setContentType(MediaType.APPLICATION_JSON);
        this.serverUrl = String.format("http://prism/prism/elasticjob/push/consume/%s", NetUtils.getLocalIp());
    }

    @EventListener(value={MainContextRefreshedEvent.class})
    public void startPush() {
        if (this.pushScheduled.isShutdown()) {
            return;
        }
        this.pushScheduled.scheduleAtFixedRate(() -> {
            try {
                this.pushTrackEvents();
            }
            catch (Exception e) {
                log.info("\u63a8\u9001elasticjob\u6570\u636e\u5f02\u5e38", (Throwable)e);
            }
        }, 1L, 5L, TimeUnit.MINUTES);
    }

    public void pushTrackEvents() {
        try {
            List<JobExecutionTrackEvent> events = this.builTrackEvents();
            if (CollectionUtils.isEmpty(events)) {
                return;
            }
            HttpEntity request = new HttpEntity((Object)JSONObject.toJSONString(events), (MultiValueMap)this.jsonHeader);
            ResponseEntity resp = this.restTemplate.postForEntity(this.serverUrl, (Object)request, String.class, new Object[0]);
            if (resp.getStatusCode() != HttpStatus.OK) {
                log.warn("\u63a8\u9001elasticjob\u6570\u636e\u5f02\u5e38\uff0c\u8fd4\u56de\u9519\u8bef\u7801\uff1a{}", (Object)resp.getStatusCode().value());
            }
        }
        catch (Exception e) {
            log.warn("\u63a8\u9001elasticjob\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    private List<JobExecutionTrackEvent> builTrackEvents() {
        boolean isPresent = ClassUtils.isPresent((String)"io.elasticjob.autoconfigure.eventbus.JobEventCacheStorage", null);
        if (!isPresent) {
            return Collections.emptyList();
        }
        List events = JobEventCacheStorage.consumeEvent();
        ArrayList trackEvents = Lists.newArrayListWithCapacity((int)events.size());
        events.forEach(event -> {
            JobExecutionTrackEvent trackEvent = (JobExecutionTrackEvent)BeanUtils.copy((Object)event, JobExecutionTrackEvent.class);
            trackEvent.setFailureCause(event.getFailureCause());
            trackEvent.setAppName(this.currentAppName);
            String cron = this.monitorManager.getJobCron(event.getJobName());
            if (StringUtils.isBlank((CharSequence)cron)) {
                return;
            }
            try {
                CronExpression cronSequenceGenerator = new CronExpression(cron);
                Date nextTime = cronSequenceGenerator.getNextValidTimeAfter(trackEvent.getStartTime());
                trackEvent.setNextTime(nextTime);
            }
            catch (Exception e) {
                log.warn("\u89e3\u6790\u4efb\u52a1\u7684\u4e0b\u6b21\u6267\u884c\u65f6\u95f4\u5f02\u5e38, jobName:{}", (Object)event.getJobName(), (Object)e);
            }
            trackEvents.add(trackEvent);
        });
        return trackEvents;
    }

    private void shutdown() {
        log.info("begin to shutdown elasticjob push server...");
        this.pushScheduled.shutdown();
        try {
            if (!this.pushScheduled.awaitTermination(5L, TimeUnit.SECONDS)) {
                log.info("\u7b49\u5f85\u8d85\u8fc75\u79d2\u4efb\u52a1\u5f3a\u5236\u5173\u95ed");
                this.pushScheduled.shutdownNow();
                if (!this.pushScheduled.awaitTermination(3L, TimeUnit.SECONDS)) {
                    log.info("\u5f53\u524d\u4efb\u52a1\u65e0\u6cd5\u5f3a\u5236\u5173\u95ed");
                }
            }
        }
        catch (InterruptedException e) {
            this.pushScheduled.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.pushTrackEvents();
    }

    public void stop() {
        this.shutdown();
    }
}

