/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.jvm;

import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.DuibaJvmMonitorProperties;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.DuibaThreadpoolExhaustedEvent;
import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.JvmAlertComponent;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationListener;

public class DuibaThreadpoolExhaustedEventListener
implements ApplicationListener<DuibaThreadpoolExhaustedEvent> {
    @Resource
    private DuibaJvmMonitorProperties duibaJvmMonitorProperties;
    @Resource
    private JvmAlertComponent jvmAlertComponent;
    private static final ReentrantLock REPORT_LOCK = new ReentrantLock();
    private static volatile long lastReportTime;
    private static final int REPORT_INTERVAL = 20000;

    public void onApplicationEvent(DuibaThreadpoolExhaustedEvent event) {
        if (!this.duibaJvmMonitorProperties.isEnableThreadDump()) {
            return;
        }
        if (StringUtils.isBlank((String)event.getThreadPoolName())) {
            return;
        }
        if (lastReportTime > event.getTimestamp() - 20000L) {
            return;
        }
        if (REPORT_LOCK.tryLock()) {
            try {
                if (lastReportTime > event.getTimestamp() - 20000L) {
                    return;
                }
                lastReportTime = event.getTimestamp();
                this.jvmAlertComponent.doThreadpoolExhaustedReport(event.getThreadPoolName());
            }
            finally {
                REPORT_LOCK.unlock();
            }
        }
    }
}

