/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.cloud.config;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.perftest.elasticjob.ElasticJobPerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.perftest.rocketmq.RocketMQPerfTestUtils;
import java.util.HashMap;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class PerfTestConfigApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static final String PERFTEST_PROPERTY_SOURCE_NAME = "duibaPerfTestConfig";
    private static volatile boolean inited = false;

    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        if (!PerfTestUtils.isPerfTestEnv()) {
            return;
        }
        if (inited) {
            return;
        }
        HashMap<String, Object> perftestPropertyMap = new HashMap<String, Object>();
        RocketMQPerfTestUtils.configProperties(configurableApplicationContext.getEnvironment(), perftestPropertyMap);
        ElasticJobPerfTestUtils.configProperties(configurableApplicationContext.getEnvironment(), perftestPropertyMap);
        ConfigurableEnvironment configurableEnvironment = configurableApplicationContext.getEnvironment();
        configurableEnvironment.getPropertySources().addFirst((PropertySource)new MapPropertySource(PERFTEST_PROPERTY_SOURCE_NAME, perftestPropertyMap));
        inited = true;
    }

    public int getOrder() {
        return -2147483628;
    }
}

