/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.datasource;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duiba.boot.utils.AopTargetUtils;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.perftest.core.PerfTestFootMarker;
import cn.com.duibaboot.ext.autoconfigure.perftest.datasource.PerfTestRoutingDataSource;
import cn.com.duibaboot.ext.autoconfigure.perftest.datasource.PerfTestRoutingDataSourceForDbcp2;
import cn.com.duibaboot.ext.autoconfigure.perftest.datasource.PerfTestRoutingDataSourceForHikari;
import com.google.common.base.Throwables;
import com.zaxxer.hikari.HikariDataSource;
import io.shardingjdbc.core.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingjdbc.core.jdbc.core.ShardingContext;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.core.rule.MasterSlaveRule;
import java.lang.reflect.Field;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.EncryptDataSource;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;

public class PerfTestDataSourcePostProcessor
implements SpecifiedBeanPostProcessor<DataSource> {
    @Resource
    private Environment environment;
    @Resource
    private ApplicationContext applicationContext;
    private PerfTestFootMarker perfTestFootMarker;

    @Override
    public Class<DataSource> getBeanType() {
        return DataSource.class;
    }

    @Override
    public Object postProcessBeforeInitialization(DataSource bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(DataSource bean, String beanName) throws BeansException {
        if (!PerfTestUtils.isPerfTestEnv()) {
            return bean;
        }
        if (PerfTestDataSourcePostProcessor.isBeanInstanceOfShardingJdbc2DataSource((DataSource)bean, beanName)) {
            return bean;
        }
        if (PerfTestDataSourcePostProcessor.isBeanInstanceOfShardingSphere4DataSource((DataSource)bean, beanName)) {
            return bean;
        }
        if (!(bean instanceof PerfTestRoutingDataSource)) {
            try {
                Class.forName("org.apache.commons.dbcp2.BasicDataSource");
                if (bean instanceof BasicDataSource) {
                    PerfTestRoutingDataSourceForDbcp2 ts = new PerfTestRoutingDataSourceForDbcp2((BasicDataSource)bean, this.environment, this.getPerfTestFootMarker());
                    ts.afterPropertiesSet();
                    bean = ts;
                    return bean;
                }
            }
            catch (Exception ts) {
                // empty catch block
            }
            try {
                Class.forName("com.zaxxer.hikari.HikariDataSource");
                if (bean instanceof HikariDataSource) {
                    PerfTestRoutingDataSourceForHikari ts = new PerfTestRoutingDataSourceForHikari((HikariDataSource)bean, this.environment, this.getPerfTestFootMarker());
                    ts.afterPropertiesSet();
                    bean = ts;
                    return bean;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IllegalStateException("\u6570\u636e\u6e90\u5fc5\u987b\u5b9a\u4e49\u4e3aHikariDataSource\u6216\u8005BasicDataSource\uff0c\u5426\u5219\u65e0\u6cd5\u652f\u6301\u538b\u6d4b\uff0c\u5982\u679c\u4f60\u9700\u8981\u4e34\u65f6\u8fc1\u79fb\u6570\u636e\u5e93\uff0c\u8bf7\u6682\u65f6\u628aspring-boot-starter-perftest\u5305\u53bb\u6389\uff0c\u5e76\u5728\u8fc1\u79fb\u5b8c\u6210\u540e\u52a0\u56de\u6765");
        }
        return bean;
    }

    public int getOrder() {
        return 0;
    }

    private PerfTestFootMarker getPerfTestFootMarker() {
        if (this.perfTestFootMarker == null) {
            this.perfTestFootMarker = (PerfTestFootMarker)this.applicationContext.getBean(PerfTestFootMarker.class);
        }
        return this.perfTestFootMarker;
    }

    private static boolean isBeanInstanceOfShardingSphere4DataSource(DataSource bean, String beanName) {
        try {
            Class.forName("org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.EncryptDataSource");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        if (!(bean instanceof EncryptDataSource)) {
            return false;
        }
        EncryptDataSource ds = (EncryptDataSource)bean;
        try {
            ds = (EncryptDataSource)AopTargetUtils.getTarget((Object)ds);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        Field field = ReflectionUtils.findField(EncryptDataSource.class, (String)"dataSourceMap");
        field.setAccessible(true);
        Map dataSourceMap = (Map)ReflectionUtils.getField((Field)field, (Object)ds);
        for (Map.Entry entry : dataSourceMap.entrySet()) {
            DataSource innerDs = (DataSource)entry.getValue();
            if (innerDs instanceof PerfTestRoutingDataSource) continue;
            throw new IllegalStateException("\u8bf7\u628a\u7684EncryptDataSource\u6570\u636e\u6e90\u5185\u90e8\u4f7f\u7528\u7684\u6570\u636e\u6e90\u6ce8\u518c\u4e3aspring\u7684bean\uff0c\u4ee5\u8ba9\u7ebf\u4e0a\u538b\u6d4b\u6846\u67b6\u6709\u673a\u4f1a\u5904\u7406\u5185\u90e8\u7684\u6570\u636e\u6e90\uff08\u5185\u90e8\u6570\u636e\u6e90\u5fc5\u987b\u4e3adbcp2/Hikari\uff09");
        }
        return true;
    }

    private static boolean isBeanInstanceOfShardingJdbc2DataSource(DataSource bean, String beanName) {
        try {
            Class.forName("io.shardingjdbc.core.jdbc.adapter.AbstractDataSourceAdapter");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        if (!(bean instanceof AbstractDataSourceAdapter)) {
            return false;
        }
        if (bean instanceof ShardingDataSource) {
            ShardingDataSource ds = (ShardingDataSource)bean;
            try {
                ds = (ShardingDataSource)AopTargetUtils.getTarget((Object)ds);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            Field field = ReflectionUtils.findField(ShardingDataSource.class, (String)"shardingContext");
            field.setAccessible(true);
            ShardingContext shardingContext = (ShardingContext)ReflectionUtils.getField((Field)field, (Object)ds);
            Map dataSourceMap = shardingContext.getShardingRule().getDataSourceMap();
            for (Map.Entry entry : dataSourceMap.entrySet()) {
                DataSource innerDs = (DataSource)entry.getValue();
                if (innerDs instanceof MasterSlaveDataSource) {
                    PerfTestDataSourcePostProcessor.processMasterSlaveDataSource((DataSource)((MasterSlaveDataSource)innerDs), beanName);
                    continue;
                }
                if (innerDs instanceof PerfTestRoutingDataSource) continue;
                PerfTestDataSourcePostProcessor.onShardingJdbcError(beanName);
            }
        } else if (bean instanceof MasterSlaveDataSource) {
            PerfTestDataSourcePostProcessor.processMasterSlaveDataSource((DataSource)((MasterSlaveDataSource)bean), beanName);
        } else {
            throw new IllegalStateException("[NOTIFYME]sharding jdbc\u65b0\u589e\u7684\u6570\u636e\u6e90\u6682\u65f6\u4e0d\u652f\u6301\uff0c\u5982\u9047\u5230\u6b64\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u67b6\u6784\u7ec4\u6dfb\u52a0\u652f\u6301");
        }
        return true;
    }

    private static void processMasterSlaveDataSource(DataSource ds, String beanName) {
        MasterSlaveDataSource ds1 = (MasterSlaveDataSource)ds;
        MasterSlaveRule oriRule = ds1.getMasterSlaveRule();
        DataSource oriMd = oriRule.getMasterDataSource();
        boolean throwException = false;
        if (!(oriMd instanceof PerfTestRoutingDataSource)) {
            throwException = true;
        }
        if (!throwException) {
            Map slaveDataSourceMap = oriRule.getSlaveDataSourceMap();
            for (Map.Entry entry : slaveDataSourceMap.entrySet()) {
                DataSource innerDs = (DataSource)entry.getValue();
                if (innerDs instanceof PerfTestRoutingDataSource) continue;
                throwException = true;
                break;
            }
        }
        if (throwException) {
            PerfTestDataSourcePostProcessor.onShardingJdbcError(beanName);
        }
    }

    private static void onShardingJdbcError(String beanName) {
        throw new IllegalStateException("\u8bf7\u628aid\u4e3a[" + beanName + "]\u7684sharding-jdbc\u6570\u636e\u6e90\u5185\u90e8\u4f7f\u7528\u7684\u6570\u636e\u6e90\u6ce8\u518c\u4e3aspring\u7684bean\uff0c\u4ee5\u8ba9\u7ebf\u4e0a\u538b\u6d4b\u6846\u67b6\u6709\u673a\u4f1a\u5904\u7406\u5185\u90e8\u7684\u6570\u636e\u6e90\uff08\u5185\u90e8\u6570\u636e\u6e90\u5fc5\u987b\u4e3adbcp2\uff09");
    }
}

