/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.datasource;

import cn.com.duibaboot.ext.autoconfigure.perftest.core.PerfTestFootMarker;
import cn.com.duibaboot.ext.autoconfigure.perftest.datasource.PerfTestRoutingDataSource;
import java.util.Collection;
import org.apache.commons.dbcp2.BasicDataSource;
import org.springframework.core.env.Environment;

public class PerfTestRoutingDataSourceForDbcp2
extends PerfTestRoutingDataSource<BasicDataSource> {
    public PerfTestRoutingDataSourceForDbcp2(BasicDataSource originalDataSource, Environment environment, PerfTestFootMarker perfTestFootMarker) {
        super(originalDataSource, environment, perfTestFootMarker);
    }

    @Override
    protected String getJdbcUrl(BasicDataSource dataSource) {
        return dataSource.getUrl();
    }

    @Override
    protected BasicDataSource copyDataSource(String testUrl, BasicDataSource originalDataSource) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(originalDataSource.getDriverClassName());
        ds.setUrl(testUrl);
        ds.setUsername(originalDataSource.getUsername());
        ds.setPassword(originalDataSource.getPassword());
        ds.setDefaultQueryTimeout(originalDataSource.getDefaultQueryTimeout());
        ds.setInitialSize(originalDataSource.getInitialSize());
        ds.setLogAbandoned(originalDataSource.getLogAbandoned());
        ds.setMaxIdle(originalDataSource.getMaxIdle());
        ds.setMaxTotal(originalDataSource.getMaxTotal());
        ds.setMinIdle(0);
        ds.setValidationQuery(originalDataSource.getValidationQuery());
        ds.setValidationQueryTimeout(originalDataSource.getValidationQueryTimeout());
        ds.setTimeBetweenEvictionRunsMillis(30000L);
        ds.setSoftMinEvictableIdleTimeMillis(30000L);
        ds.setTestWhileIdle(originalDataSource.getTestWhileIdle());
        ds.setTestOnBorrow(originalDataSource.getTestOnBorrow());
        ds.setTestOnReturn(originalDataSource.getTestOnReturn());
        ds.setTestOnCreate(originalDataSource.getTestOnCreate());
        ds.setMaxWaitMillis(originalDataSource.getMaxWaitMillis());
        ds.setNumTestsPerEvictionRun(originalDataSource.getNumTestsPerEvictionRun());
        ds.setRemoveAbandonedOnBorrow(originalDataSource.getRemoveAbandonedOnBorrow());
        ds.setRemoveAbandonedOnMaintenance(originalDataSource.getRemoveAbandonedOnMaintenance());
        ds.setRemoveAbandonedTimeout(originalDataSource.getRemoveAbandonedTimeout());
        ds.setConnectionInitSqls((Collection)originalDataSource.getConnectionInitSqls());
        return ds;
    }
}

