/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.dubbo;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;

public class PerfTestRegistryFactoryWrapper
implements RegistryFactory {
    private final RegistryFactory registryFactory;

    public PerfTestRegistryFactoryWrapper(RegistryFactory registryFactory) {
        this.registryFactory = registryFactory;
    }

    public Registry getRegistry(URL url) {
        return new RegistryWrapper(this.registryFactory.getRegistry(url));
    }

    private static class RegistryWrapper
    implements Registry {
        private final Registry originRegistry;

        private URL appendProviderPerfTestKey(URL url) {
            String side = url.getParameter("side");
            if ("provider".equals(side)) {
                url = url.addParameter("isPerfTestSupportted", true);
                if (PerfTestUtils.isPerfTestEnv()) {
                    url = url.addParameter("duibaNewPerfSceneId", PerfTestUtils.getSceneId());
                }
            }
            return url;
        }

        public RegistryWrapper(Registry originRegistry) {
            this.originRegistry = originRegistry;
        }

        public URL getUrl() {
            return this.originRegistry.getUrl();
        }

        public boolean isAvailable() {
            return this.originRegistry.isAvailable();
        }

        public void destroy() {
            this.originRegistry.destroy();
        }

        public void register(URL url) {
            this.originRegistry.register(this.appendProviderPerfTestKey(url));
        }

        public void unregister(URL url) {
            this.originRegistry.unregister(this.appendProviderPerfTestKey(url));
        }

        public void subscribe(URL url, NotifyListener listener) {
            this.originRegistry.subscribe(url, listener);
        }

        public void unsubscribe(URL url, NotifyListener listener) {
            this.originRegistry.unsubscribe(url, listener);
        }

        public List<URL> lookup(URL url) {
            return this.originRegistry.lookup(this.appendProviderPerfTestKey(url));
        }
    }
}

