/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.CommonDiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.web.ServerReadyStatusHolder;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class ServiceReadyFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceReadyFilter.class);
    private final Integer duibaWarmUpTimeMillis;

    public ServiceReadyFilter(Integer duibaWarmUpTimeMillis) {
        this.duibaWarmUpTimeMillis = duibaWarmUpTimeMillis;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestPath = RequestUtils.getRequestPath((HttpServletRequest)request);
        if (requestPath.equals("/isReady")) {
            if (!ServerReadyStatusHolder.isReady()) {
                long serverStartUpTime = CommonDiscoveryMetadataRegister.getServerStartUpTimeOuternal();
                long currentTime = System.currentTimeMillis();
                if (serverStartUpTime > 0L && serverStartUpTime + (long)this.duibaWarmUpTimeMillis.intValue() < currentTime) {
                    ServerReadyStatusHolder.makeReady();
                    LOGGER.warn("\u9884\u70ed\u5b8c\u6210, \u5e94\u7528\u5c31\u7eea, serverStartUpTime={}, duibaWarmUpTimeMillis={}, currentTime={}", new Object[]{DateUtils.getSecondStr((long)serverStartUpTime), this.duibaWarmUpTimeMillis, DateUtils.getSecondStr((long)currentTime)});
                }
                response.setStatus(ServerReadyStatusHolder.isReady() ? HttpStatus.OK.value() : HttpStatus.SERVICE_UNAVAILABLE.value());
            }
            response.getWriter().write(ServerReadyStatusHolder.isReady() ? "OK" : "INVALID");
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}

