/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.nustaq.serialization.util;

import shaded.org.nustaq.serialization.util.FSTInt2ObjectMap;
import shaded.org.nustaq.serialization.util.FSTObject2IntMap;
import shaded.org.nustaq.serialization.util.FSTUtil;

public class DefaultFSTInt2ObjectMap<V>
implements FSTInt2ObjectMap<V> {
    private int[] mKeys;
    private Object[] mValues;
    private int mNumberOfElements;
    private DefaultFSTInt2ObjectMap<V> next;
    private static final int GROWFAC = 2;

    public DefaultFSTInt2ObjectMap(int initialSize) {
        if (initialSize < 2) {
            initialSize = 2;
        }
        initialSize = FSTObject2IntMap.adjustSize(initialSize * 2);
        this.mKeys = new int[initialSize];
        this.mValues = new Object[initialSize];
        this.mNumberOfElements = 0;
    }

    @Override
    public int size() {
        return this.mNumberOfElements + (this.next != null ? this.next.size() : 0);
    }

    @Override
    public final void put(int key, V value) {
        int hash = key & Integer.MAX_VALUE;
        if (key == 0 && value == null) {
            throw new RuntimeException("key value pair not supported " + key + " " + value);
        }
        this.putHash(key, value, hash, this);
    }

    private static final <V> void putHash(int key, V value, int hash, DefaultFSTInt2ObjectMap<V> current, DefaultFSTInt2ObjectMap<V> parent) {
        int count = 0;
        while (true) {
            int idx;
            if (current.mNumberOfElements * 2 > current.mKeys.length) {
                if (parent != null) {
                    if ((parent.mNumberOfElements + current.mNumberOfElements) * 2 > parent.mKeys.length) {
                        parent.resize(parent.mKeys.length * 2);
                        parent.put(key, value);
                        return;
                    }
                    current.resize(current.mKeys.length * 2);
                } else {
                    current.resize(current.mKeys.length * 2);
                }
            }
            if (current.mKeys[idx = hash % current.mKeys.length] == 0 && current.mValues[idx] == null) {
                ++current.mNumberOfElements;
                current.mValues[idx] = value;
                current.mKeys[idx] = key;
                return;
            }
            if (current.mKeys[idx] == key) {
                current.mValues[idx] = value;
                return;
            }
            if (current.next == null) {
                int newSiz;
                if (count > 4 && current.mNumberOfElements < 5) {
                    newSiz = current.mNumberOfElements * 2 + 1;
                    current.next = new DefaultFSTInt2ObjectMap<V>(newSiz);
                    count = 0;
                } else {
                    newSiz = current.mNumberOfElements / 3;
                    current.next = new DefaultFSTInt2ObjectMap<V>(newSiz);
                }
            }
            parent = current;
            current = current.next;
            ++count;
        }
    }

    final void putHash(int key, V value, int hash, DefaultFSTInt2ObjectMap<V> parent) {
        DefaultFSTInt2ObjectMap.putHash(key, value, hash, this, parent);
    }

    @Override
    public final V get(int key) {
        int hash = key & Integer.MAX_VALUE;
        return this.getHash(key, hash);
    }

    final V getHash(int key, int hash) {
        int idx = hash % this.mKeys.length;
        int mKey = this.mKeys[idx];
        Object mValue = this.mValues[idx];
        if (mKey == 0 && mValue == null) {
            return null;
        }
        if (mKey == key) {
            return (V)mValue;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.getHash(key, hash);
    }

    final void resize(int newSize) {
        newSize = FSTObject2IntMap.adjustSize(newSize);
        int[] oldTabKey = this.mKeys;
        Object[] oldTabVal = this.mValues;
        this.mKeys = new int[newSize];
        this.mValues = new Object[newSize];
        this.mNumberOfElements = 0;
        for (int n = 0; n < oldTabKey.length; ++n) {
            if (oldTabKey[n] == 0 && oldTabVal[n] == null) continue;
            this.put(oldTabKey[n], oldTabVal[n]);
        }
        if (this.next != null) {
            DefaultFSTInt2ObjectMap<V> oldNext = this.next;
            this.next = null;
            super.rePut(this);
        }
    }

    private void rePut(DefaultFSTInt2ObjectMap<V> kfstObject2IntMap) {
        for (int i = 0; i < this.mKeys.length; ++i) {
            int mKey = this.mKeys[i];
            if (mKey == 0 && this.mValues[i] == null) continue;
            kfstObject2IntMap.put(mKey, this.mValues[i]);
        }
        if (this.next != null) {
            super.rePut(kfstObject2IntMap);
        }
    }

    @Override
    public void clear() {
        int size = this.size();
        if (size == 0) {
            return;
        }
        if (this.mKeys.length > 6 * this.size() && size > 0) {
            if (size < 2) {
                size = 2;
            }
            size = FSTObject2IntMap.adjustSize(size * 2);
            this.mKeys = new int[size];
            this.mValues = new Object[size];
            this.mNumberOfElements = 0;
        } else {
            FSTUtil.clear(this.mKeys);
            FSTUtil.clear(this.mValues);
            this.mNumberOfElements = 0;
            if (this.next != null) {
                this.next.clear();
            }
        }
    }
}

