package cn.com.duibaboot.ext.autoconfigure.accesslog;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ClassPathResource;

import javax.servlet.DispatcherType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 *
 * 通用URL 日志打印,统一日志格式,用于收集日志,方便实时采集到大数据平台
 * Created by xuhengfei on 16/12/20.
 */
@Configuration
@ConditionalOnClass({LoggerContext.class})
@ConditionalOnResource(resources = "classpath:logback/access-logback.xml")
@ConditionalOnWebApplication
public class AccessLogAutoConfiguration {

    private static final Logger logger = LoggerFactory.getLogger(AccessLogAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass({LoggerContext.class})
    @ConditionalOnResource(resources = "classpath:logback/access-logback.xml")
    @ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
    public static class AccessLogServletFilterConfiguration{

        @Bean
        public AccessLogFilter accessLogFilter(){
            return new AccessLogFilter();
        }

        @Bean
        public FilterRegistrationBean acesslogHttpFilterConfigurer(AccessLogFilter accessLogFilter){
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter(accessLogFilter);
            List<String> urlPatterns=new ArrayList<>();
            urlPatterns.add("/*");//拦截路径，可以添加多个
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(100);

            return registrationBean;
        }
    }

    @Configuration
    @ConditionalOnClass({LoggerContext.class})
    @ConditionalOnResource(resources = "classpath:logback/access-logback.xml")
    @ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
    public static class AccessLogReactiveFilterConfiguration{

        @Bean
        @Order(100)
        public AccessLogReactiveFilter accessLogReactiveFilter(){
            return new AccessLogReactiveFilter();
        }

    }

    /**
     * 附加logback配置文件
     * @return
     */
    @Bean
    public ApplicationListener<ContextRefreshedEvent> accesslogLogbackConfig() {
        return new AccesslogLogbackApplicationListener();
    }

    public static class AccesslogLogbackApplicationListener implements ApplicationListener<ContextRefreshedEvent>, Ordered {

        private volatile boolean flag = true;

        @Override
        public void onApplicationEvent(ContextRefreshedEvent event) {
            if (flag) {
                try {
                    LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
                    JoranConfigurator configurator = new JoranConfigurator();
                    configurator.setContext(loggerContext);
                    //logback 添加新的配置文件
                    configurator.doConfigure(new ClassPathResource("/logback/access-logback.xml").getInputStream());
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
                flag = false;
            }
        }

        @Override
        public int getOrder() {
            return -20;
        }
    }
}
