package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * Hbase自动配置
 */
@Configuration
@ConditionalOnClass({Connection.class})
@EnableConfigurationProperties(HbaseProperties.class)
@Import(ExtraHbaseImportBeanDefinitionRegistrar.class)
public class HbaseAutoConfiguration {

    @Resource
    private HbaseProperties hbaseProperties;

    @Bean("connection")
    @ConditionalOnProperty(name="duiba.hbase.zk-quorum", matchIfMissing = false)
    @ConditionalOnMissingBean(value=Connection.class, name="connection")
    public Connection connection() throws IOException {
        org.apache.hadoop.conf.Configuration configuration = hbaseProperties.getConfiguration();
        //获得hbase connection连接池
        Connection connection = ConnectionFactory.createConnection(configuration);
        return connection;
    }

}
