package cn.com.duibaboot.ext.autoconfigure.dbexec;

import lombok.Getter;

/**
 * Created by guoyanfei .
 * 2021/6/3 .
 */
public enum AsyncProfilerCommand {

    CPU("cpu", "%s -d 20 -e cpu -f %s %s"),
    ALLOC("alloc", "%s -d 20 -e alloc -f %s %s"),
    LOCK("lock", "%s -d 20 -e lock -f %s %s"),
    WALL("wall", "%s -d 20 -e wall -f %s %s"),
    ITIMER("itimer", "%s -d 20 -e itimer -f %s %s");

    @Getter
    private String commandKey;

    @Getter
    private String command;

    AsyncProfilerCommand(String commandKey, String command) {
        this.commandKey = commandKey;
        this.command = command;
    }

    public static AsyncProfilerCommand get(String commandKey) {
        for (AsyncProfilerCommand item : AsyncProfilerCommand.values()) {
            if (item.getCommandKey().equals(commandKey)) {
                return item;
            }
        }
        return null;
    }

    public static boolean contains(String commandKey) {
        return get(commandKey) != null;
    }

}
