package cn.com.duibaboot.ext.autoconfigure.monitor.jvm;

import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationListener;

import javax.annotation.Resource;
import java.util.concurrent.locks.ReentrantLock;

/**
 * 兑吧ext的线程池耗尽事件监听器
 * 监听到耗尽事件后，上报到prism，prism通过调用当前实例的 /threaddump 获取线程dump，20秒内单个实例只会上报一次
 * Created by guoyanfei .
 * 2021/6/17 .
 */
public class DuibaThreadpoolExhaustedEventListener implements ApplicationListener<DuibaThreadpoolExhaustedEvent> {

    @Resource
    private DuibaJvmMonitorProperties duibaJvmMonitorProperties;

    @Resource
    private JvmAlertComponent jvmAlertComponent;

    private static final ReentrantLock REPORT_LOCK = new ReentrantLock();

    /**
     * 上一次报告线程池耗尽的时间
     */
    private static volatile long lastReportTime;

    /**
     * 每次上报间隔时间，20秒
     */
    private static final int REPORT_INTERVAL = 20000;

    @Override
    public void onApplicationEvent(DuibaThreadpoolExhaustedEvent event) {
        if (!duibaJvmMonitorProperties.isEnableThreadDump()) {
            return;
        }
        // 这种情况一般不是ext的threadpool
        if (StringUtils.isBlank(event.getThreadPoolName())) {
            return;
        }
        if (lastReportTime > event.getTimestamp() - REPORT_INTERVAL) {
            return;
        }
        if (REPORT_LOCK.tryLock()) {
            try {
                if (lastReportTime > event.getTimestamp() - REPORT_INTERVAL) {
                    return;
                }
                lastReportTime = event.getTimestamp();
                jvmAlertComponent.doThreadpoolExhaustedReport(event.getThreadPoolName());
            } finally {
                REPORT_LOCK.unlock();
            }
        }
    }
}
