package cn.com.duibaboot.ext.autoconfigure.perftest.cloud.config;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.perftest.elasticjob.ElasticJobPerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.perftest.rocketmq.RocketMQPerfTestUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;

import java.util.HashMap;
import java.util.Map;

/**
 * 压测相关的配置项进行特殊处理
 * 1、elasticjob在压测机器禁止执行
 * 2、rocketmq在压测机器使用压测专用的namesrv
 * Created by guoyanfei .
 * 2022/2/21 .
 */
public class PerfTestConfigApplicationContextInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext>, Ordered {

    private static final String PERFTEST_PROPERTY_SOURCE_NAME = "duibaPerfTestConfig";

    /**
     * 刷新的时候不再执行
     */
    private static volatile boolean inited = false;

    @Override
    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        // 当前不是压测环境，不做任何处理
        if (!PerfTestUtils.isPerfTestEnv()) {
            return;
        }
        if (inited) {  // 已经在应用刚启动完成的时候做过压测相关配置的初始化，不可以进行刷新
            return;
        }

        Map<String, Object> perftestPropertyMap = new HashMap<>();

        // rocketmq支持压测，使用压测专用的namesrv
        RocketMQPerfTestUtils.configProperties(configurableApplicationContext.getEnvironment(), perftestPropertyMap);
        // elasticJob支持压测，禁用 ElasticJobAutoConfiguration
        ElasticJobPerfTestUtils.configProperties(configurableApplicationContext.getEnvironment(), perftestPropertyMap);

        ConfigurableEnvironment configurableEnvironment = configurableApplicationContext.getEnvironment();
        configurableEnvironment.getPropertySources().addFirst(new MapPropertySource(PERFTEST_PROPERTY_SOURCE_NAME, perftestPropertyMap));

        inited = true;
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE + 20;
    }
}
